/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.models.UserEntityBaseParameters;
import com.azure.resourcemanager.apimanagement.models.UserState;
import java.io.IOException;
import java.util.List;

public final class UserUpdateParametersProperties
extends UserEntityBaseParameters {
    private String email;
    private String password;
    private String firstName;
    private String lastName;

    public String email() {
        return this.email;
    }

    public UserUpdateParametersProperties withEmail(String email) {
        this.email = email;
        return this;
    }

    public String password() {
        return this.password;
    }

    public UserUpdateParametersProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public String firstName() {
        return this.firstName;
    }

    public UserUpdateParametersProperties withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return this.lastName;
    }

    public UserUpdateParametersProperties withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Override
    public UserUpdateParametersProperties withState(UserState state) {
        super.withState(state);
        return this;
    }

    @Override
    public UserUpdateParametersProperties withNote(String note) {
        super.withNote(note);
        return this;
    }

    @Override
    public UserUpdateParametersProperties withIdentities(List<UserIdentityContractInner> identities) {
        super.withIdentities(identities);
        return this;
    }

    @Override
    public void validate() {
        if (this.identities() != null) {
            this.identities().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("note", this.note());
        jsonWriter.writeArrayField("identities", this.identities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("firstName", this.firstName);
        jsonWriter.writeStringField("lastName", this.lastName);
        return jsonWriter.writeEndObject();
    }

    public static UserUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UserUpdateParametersProperties)jsonReader.readObject(reader -> {
            UserUpdateParametersProperties deserializedUserUpdateParametersProperties = new UserUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedUserUpdateParametersProperties.withState(UserState.fromString(reader.getString()));
                    continue;
                }
                if ("note".equals(fieldName)) {
                    deserializedUserUpdateParametersProperties.withNote(reader.getString());
                    continue;
                }
                if ("identities".equals(fieldName)) {
                    List identities = reader.readArray(reader1 -> UserIdentityContractInner.fromJson(reader1));
                    deserializedUserUpdateParametersProperties.withIdentities(identities);
                    continue;
                }
                if ("email".equals(fieldName)) {
                    deserializedUserUpdateParametersProperties.email = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedUserUpdateParametersProperties.password = reader.getString();
                    continue;
                }
                if ("firstName".equals(fieldName)) {
                    deserializedUserUpdateParametersProperties.firstName = reader.getString();
                    continue;
                }
                if ("lastName".equals(fieldName)) {
                    deserializedUserUpdateParametersProperties.lastName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserUpdateParametersProperties;
        });
    }
}

