/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WorkspaceContractProperties
implements JsonSerializable<WorkspaceContractProperties> {
    private String displayName;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceContractProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public WorkspaceContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public WorkspaceContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model WorkspaceContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceContractProperties)jsonReader.readObject(reader -> {
            WorkspaceContractProperties deserializedWorkspaceContractProperties = new WorkspaceContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedWorkspaceContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWorkspaceContractProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceContractProperties;
        });
    }
}

