/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiContract;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdateParameter;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdatePropertiesWsdlSelector;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.ApiUpdateContract;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContractDetails;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.ContentFormat;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SoapApiType;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import com.azure.resourcemanager.apimanagement.models.TranslateRequiredQueryParametersConduct;
import java.util.Collections;
import java.util.List;

public final class ApiContractImpl
implements ApiContract,
ApiContract.Definition,
ApiContract.Update {
    private ApiContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String createIfMatch;
    private ApiCreateOrUpdateParameter createParameters;
    private String updateIfMatch;
    private ApiUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String sourceApiId() {
        return this.innerModel().sourceApiId();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String serviceUrl() {
        return this.innerModel().serviceUrl();
    }

    @Override
    public String path() {
        return this.innerModel().path();
    }

    @Override
    public List<Protocol> protocols() {
        List<Protocol> inner = this.innerModel().protocols();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ApiVersionSetContractDetails apiVersionSet() {
        return this.innerModel().apiVersionSet();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public AuthenticationSettingsContract authenticationSettings() {
        return this.innerModel().authenticationSettings();
    }

    @Override
    public SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames() {
        return this.innerModel().subscriptionKeyParameterNames();
    }

    @Override
    public ApiType apiType() {
        return this.innerModel().apiType();
    }

    @Override
    public String apiRevision() {
        return this.innerModel().apiRevision();
    }

    @Override
    public String apiVersion() {
        return this.innerModel().apiVersion();
    }

    @Override
    public Boolean isCurrent() {
        return this.innerModel().isCurrent();
    }

    @Override
    public Boolean isOnline() {
        return this.innerModel().isOnline();
    }

    @Override
    public String apiRevisionDescription() {
        return this.innerModel().apiRevisionDescription();
    }

    @Override
    public String apiVersionDescription() {
        return this.innerModel().apiVersionDescription();
    }

    @Override
    public String apiVersionSetId() {
        return this.innerModel().apiVersionSetId();
    }

    @Override
    public Boolean subscriptionRequired() {
        return this.innerModel().subscriptionRequired();
    }

    @Override
    public String termsOfServiceUrl() {
        return this.innerModel().termsOfServiceUrl();
    }

    @Override
    public ApiContactInformation contact() {
        return this.innerModel().contact();
    }

    @Override
    public ApiLicenseInformation license() {
        return this.innerModel().license();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public ApiContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApis().createOrUpdate(this.resourceGroupName, this.serviceName, this.apiId, this.createParameters, this.createIfMatch, Context.NONE);
        return this;
    }

    @Override
    public ApiContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApis().createOrUpdate(this.resourceGroupName, this.serviceName, this.apiId, this.createParameters, this.createIfMatch, context);
        return this;
    }

    ApiContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ApiContractInner();
        this.serviceManager = serviceManager;
        this.apiId = name;
        this.createIfMatch = null;
        this.createParameters = new ApiCreateOrUpdateParameter();
    }

    @Override
    public ApiContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ApiUpdateContract();
        return this;
    }

    @Override
    public ApiContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApis().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApis().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    ApiContractImpl(ApiContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
    }

    @Override
    public ApiContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApis().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApis().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, context).getValue();
        return this;
    }

    @Override
    public ApiContractImpl withValue(String value) {
        this.createParameters.withValue(value);
        return this;
    }

    @Override
    public ApiContractImpl withFormat(ContentFormat format) {
        this.createParameters.withFormat(format);
        return this;
    }

    @Override
    public ApiContractImpl withWsdlSelector(ApiCreateOrUpdatePropertiesWsdlSelector wsdlSelector) {
        this.createParameters.withWsdlSelector(wsdlSelector);
        return this;
    }

    @Override
    public ApiContractImpl withSoapApiType(SoapApiType soapApiType) {
        this.createParameters.withSoapApiType(soapApiType);
        return this;
    }

    @Override
    public ApiContractImpl withTranslateRequiredQueryParametersConduct(TranslateRequiredQueryParametersConduct translateRequiredQueryParametersConduct) {
        this.createParameters.withTranslateRequiredQueryParametersConduct(translateRequiredQueryParametersConduct);
        return this;
    }

    @Override
    public ApiContractImpl withSourceApiId(String sourceApiId) {
        this.createParameters.withSourceApiId(sourceApiId);
        return this;
    }

    @Override
    public ApiContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.createParameters.withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public ApiContractImpl withServiceUrl(String serviceUrl) {
        if (this.isInCreateMode()) {
            this.createParameters.withServiceUrl(serviceUrl);
            return this;
        }
        this.updateParameters.withServiceUrl(serviceUrl);
        return this;
    }

    @Override
    public ApiContractImpl withPath(String path) {
        if (this.isInCreateMode()) {
            this.createParameters.withPath(path);
            return this;
        }
        this.updateParameters.withPath(path);
        return this;
    }

    @Override
    public ApiContractImpl withProtocols(List<Protocol> protocols) {
        if (this.isInCreateMode()) {
            this.createParameters.withProtocols(protocols);
            return this;
        }
        this.updateParameters.withProtocols(protocols);
        return this;
    }

    @Override
    public ApiContractImpl withApiVersionSet(ApiVersionSetContractDetails apiVersionSet) {
        this.createParameters.withApiVersionSet(apiVersionSet);
        return this;
    }

    @Override
    public ApiContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public ApiContractImpl withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        if (this.isInCreateMode()) {
            this.createParameters.withAuthenticationSettings(authenticationSettings);
            return this;
        }
        this.updateParameters.withAuthenticationSettings(authenticationSettings);
        return this;
    }

    @Override
    public ApiContractImpl withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        if (this.isInCreateMode()) {
            this.createParameters.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
            return this;
        }
        this.updateParameters.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
        return this;
    }

    @Override
    public ApiContractImpl withApiType(ApiType apiType) {
        if (this.isInCreateMode()) {
            this.createParameters.withApiType(apiType);
            return this;
        }
        this.updateParameters.withApiType(apiType);
        return this;
    }

    @Override
    public ApiContractImpl withApiRevision(String apiRevision) {
        if (this.isInCreateMode()) {
            this.createParameters.withApiRevision(apiRevision);
            return this;
        }
        this.updateParameters.withApiRevision(apiRevision);
        return this;
    }

    @Override
    public ApiContractImpl withApiVersion(String apiVersion) {
        if (this.isInCreateMode()) {
            this.createParameters.withApiVersion(apiVersion);
            return this;
        }
        this.updateParameters.withApiVersion(apiVersion);
        return this;
    }

    @Override
    public ApiContractImpl withIsCurrent(Boolean isCurrent) {
        if (this.isInCreateMode()) {
            this.createParameters.withIsCurrent(isCurrent);
            return this;
        }
        this.updateParameters.withIsCurrent(isCurrent);
        return this;
    }

    @Override
    public ApiContractImpl withApiRevisionDescription(String apiRevisionDescription) {
        if (this.isInCreateMode()) {
            this.createParameters.withApiRevisionDescription(apiRevisionDescription);
            return this;
        }
        this.updateParameters.withApiRevisionDescription(apiRevisionDescription);
        return this;
    }

    @Override
    public ApiContractImpl withApiVersionDescription(String apiVersionDescription) {
        if (this.isInCreateMode()) {
            this.createParameters.withApiVersionDescription(apiVersionDescription);
            return this;
        }
        this.updateParameters.withApiVersionDescription(apiVersionDescription);
        return this;
    }

    @Override
    public ApiContractImpl withApiVersionSetId(String apiVersionSetId) {
        if (this.isInCreateMode()) {
            this.createParameters.withApiVersionSetId(apiVersionSetId);
            return this;
        }
        this.updateParameters.withApiVersionSetId(apiVersionSetId);
        return this;
    }

    @Override
    public ApiContractImpl withSubscriptionRequired(Boolean subscriptionRequired) {
        if (this.isInCreateMode()) {
            this.createParameters.withSubscriptionRequired(subscriptionRequired);
            return this;
        }
        this.updateParameters.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ApiContractImpl withTermsOfServiceUrl(String termsOfServiceUrl) {
        if (this.isInCreateMode()) {
            this.createParameters.withTermsOfServiceUrl(termsOfServiceUrl);
            return this;
        }
        this.updateParameters.withTermsOfServiceUrl(termsOfServiceUrl);
        return this;
    }

    @Override
    public ApiContractImpl withContact(ApiContactInformation contact) {
        if (this.isInCreateMode()) {
            this.createParameters.withContact(contact);
            return this;
        }
        this.updateParameters.withContact(contact);
        return this;
    }

    @Override
    public ApiContractImpl withLicense(ApiLicenseInformation license) {
        if (this.isInCreateMode()) {
            this.createParameters.withLicense(license);
            return this;
        }
        this.updateParameters.withLicense(license);
        return this;
    }

    @Override
    public ApiContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

