/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiDiagnosticsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.DiagnosticContractInner;
import com.azure.resourcemanager.apimanagement.implementation.DiagnosticContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiDiagnostics;
import com.azure.resourcemanager.apimanagement.models.ApiDiagnosticsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiDiagnosticsGetResponse;
import com.azure.resourcemanager.apimanagement.models.DiagnosticContract;

public final class ApiDiagnosticsImpl
implements ApiDiagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(ApiDiagnosticsImpl.class);
    private final ApiDiagnosticsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiDiagnosticsImpl(ApiDiagnosticsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DiagnosticContract> listByService(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<DiagnosticContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticContractImpl((DiagnosticContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DiagnosticContract> listByService(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<DiagnosticContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticContractImpl((DiagnosticContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiDiagnosticsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String diagnosticId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, diagnosticId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String diagnosticId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, diagnosticId);
    }

    @Override
    public Response<DiagnosticContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String diagnosticId, Context context) {
        ApiDiagnosticsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, diagnosticId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DiagnosticContract get(String resourceGroupName, String serviceName, String apiId, String diagnosticId) {
        DiagnosticContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, diagnosticId);
        if (inner != null) {
            return new DiagnosticContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String diagnosticId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, diagnosticId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String diagnosticId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, diagnosticId, ifMatch);
    }

    @Override
    public DiagnosticContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String diagnosticId = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        return (DiagnosticContract)this.getWithResponse(resourceGroupName, serviceName, apiId, diagnosticId, Context.NONE).getValue();
    }

    @Override
    public Response<DiagnosticContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String diagnosticId = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, diagnosticId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String diagnosticId = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, diagnosticId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String diagnosticId = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, diagnosticId, ifMatch, context);
    }

    private ApiDiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public DiagnosticContractImpl define(String name) {
        return new DiagnosticContractImpl(name, this.manager());
    }
}

