/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiGatewayConfigConnectionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayConfigConnectionResourceInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementGatewayConfigConnectionResourceImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiGatewayConfigConnections;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayConfigConnectionResource;

public final class ApiGatewayConfigConnectionsImpl
implements ApiGatewayConfigConnections {
    private static final ClientLogger LOGGER = new ClientLogger(ApiGatewayConfigConnectionsImpl.class);
    private final ApiGatewayConfigConnectionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiGatewayConfigConnectionsImpl(ApiGatewayConfigConnectionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiManagementGatewayConfigConnectionResource> listByGateway(String resourceGroupName, String gatewayName) {
        PagedIterable<ApiManagementGatewayConfigConnectionResourceInner> inner = this.serviceClient().listByGateway(resourceGroupName, gatewayName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementGatewayConfigConnectionResourceImpl((ApiManagementGatewayConfigConnectionResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementGatewayConfigConnectionResource> listByGateway(String resourceGroupName, String gatewayName, Context context) {
        PagedIterable<ApiManagementGatewayConfigConnectionResourceInner> inner = this.serviceClient().listByGateway(resourceGroupName, gatewayName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementGatewayConfigConnectionResourceImpl((ApiManagementGatewayConfigConnectionResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ApiManagementGatewayConfigConnectionResource> getWithResponse(String resourceGroupName, String gatewayName, String configConnectionName, Context context) {
        Response<ApiManagementGatewayConfigConnectionResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, gatewayName, configConnectionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiManagementGatewayConfigConnectionResourceImpl((ApiManagementGatewayConfigConnectionResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource get(String resourceGroupName, String gatewayName, String configConnectionName) {
        ApiManagementGatewayConfigConnectionResourceInner inner = this.serviceClient().get(resourceGroupName, gatewayName, configConnectionName);
        if (inner != null) {
            return new ApiManagementGatewayConfigConnectionResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, gatewayName, configConnectionName, ifMatch);
    }

    @Override
    public void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, gatewayName, configConnectionName, ifMatch, context);
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        return (ApiManagementGatewayConfigConnectionResource)this.getWithResponse(resourceGroupName, gatewayName, configConnectionName, Context.NONE).getValue();
    }

    @Override
    public Response<ApiManagementGatewayConfigConnectionResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        return this.getWithResponse(resourceGroupName, gatewayName, configConnectionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, gatewayName, configConnectionName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        this.delete(resourceGroupName, gatewayName, configConnectionName, ifMatch, context);
    }

    private ApiGatewayConfigConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResourceImpl define(String name) {
        return new ApiManagementGatewayConfigConnectionResourceImpl(name, this.manager());
    }
}

