/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiIssueAttachmentsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueAttachmentContractInner;
import com.azure.resourcemanager.apimanagement.implementation.IssueAttachmentContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiIssueAttachments;
import com.azure.resourcemanager.apimanagement.models.ApiIssueAttachmentsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiIssueAttachmentsGetResponse;
import com.azure.resourcemanager.apimanagement.models.IssueAttachmentContract;

public final class ApiIssueAttachmentsImpl
implements ApiIssueAttachments {
    private static final ClientLogger LOGGER = new ClientLogger(ApiIssueAttachmentsImpl.class);
    private final ApiIssueAttachmentsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiIssueAttachmentsImpl(ApiIssueAttachmentsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IssueAttachmentContract> listByService(String resourceGroupName, String serviceName, String apiId, String issueId) {
        PagedIterable<IssueAttachmentContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, issueId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueAttachmentContractImpl((IssueAttachmentContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IssueAttachmentContract> listByService(String resourceGroupName, String serviceName, String apiId, String issueId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<IssueAttachmentContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, issueId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueAttachmentContractImpl((IssueAttachmentContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiIssueAttachmentsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, String attachmentId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String issueId, String attachmentId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, issueId, attachmentId);
    }

    @Override
    public Response<IssueAttachmentContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, String attachmentId, Context context) {
        ApiIssueAttachmentsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IssueAttachmentContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IssueAttachmentContract get(String resourceGroupName, String serviceName, String apiId, String issueId, String attachmentId) {
        IssueAttachmentContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, issueId, attachmentId);
        if (inner != null) {
            return new IssueAttachmentContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, String attachmentId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String issueId, String attachmentId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, issueId, attachmentId, ifMatch);
    }

    @Override
    public IssueAttachmentContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        return (IssueAttachmentContract)this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, Context.NONE).getValue();
    }

    @Override
    public Response<IssueAttachmentContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, ifMatch, context);
    }

    private ApiIssueAttachmentsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IssueAttachmentContractImpl define(String name) {
        return new IssueAttachmentContractImpl(name, this.manager());
    }
}

