/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiIssuesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueContractInner;
import com.azure.resourcemanager.apimanagement.implementation.IssueContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiIssues;
import com.azure.resourcemanager.apimanagement.models.ApiIssuesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiIssuesGetResponse;
import com.azure.resourcemanager.apimanagement.models.IssueContract;

public final class ApiIssuesImpl
implements ApiIssues {
    private static final ClientLogger LOGGER = new ClientLogger(ApiIssuesImpl.class);
    private final ApiIssuesClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiIssuesImpl(ApiIssuesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IssueContract> listByService(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<IssueContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueContractImpl((IssueContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IssueContract> listByService(String resourceGroupName, String serviceName, String apiId, String filter, Boolean expandCommentsAttachments, Integer top, Integer skip, Context context) {
        PagedIterable<IssueContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, filter, expandCommentsAttachments, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueContractImpl((IssueContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiIssuesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, issueId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String issueId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, issueId);
    }

    @Override
    public Response<IssueContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, Boolean expandCommentsAttachments, Context context) {
        ApiIssuesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, issueId, expandCommentsAttachments, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IssueContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IssueContract get(String resourceGroupName, String serviceName, String apiId, String issueId) {
        IssueContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, issueId);
        if (inner != null) {
            return new IssueContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String issueId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, issueId, ifMatch);
    }

    @Override
    public IssueContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        Boolean localExpandCommentsAttachments = null;
        return (IssueContract)this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, localExpandCommentsAttachments, Context.NONE).getValue();
    }

    @Override
    public Response<IssueContract> getByIdWithResponse(String id, Boolean expandCommentsAttachments, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, expandCommentsAttachments, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, ifMatch, context);
    }

    private ApiIssuesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IssueContractImpl define(String name) {
        return new IssueContractImpl(name, this.manager());
    }
}

