/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayResource;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuPropertiesForPatch;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class ApiManagementGatewayResourceImpl
implements ApiManagementGatewayResource,
ApiManagementGatewayResource.Definition,
ApiManagementGatewayResource.Update {
    private ApiManagementGatewayResourceInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String gatewayName;
    private ApiManagementGatewayUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ApiManagementGatewaySkuProperties sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String targetProvisioningState() {
        return this.innerModel().targetProvisioningState();
    }

    @Override
    public OffsetDateTime createdAtUtc() {
        return this.innerModel().createdAtUtc();
    }

    @Override
    public FrontendConfiguration frontend() {
        return this.innerModel().frontend();
    }

    @Override
    public BackendConfiguration backend() {
        return this.innerModel().backend();
    }

    @Override
    public GatewayConfigurationApi configurationApi() {
        return this.innerModel().configurationApi();
    }

    @Override
    public VirtualNetworkType virtualNetworkType() {
        return this.innerModel().virtualNetworkType();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiManagementGatewayResourceInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiManagementGatewayResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ApiManagementGatewayResource create() {
        this.innerObject = this.serviceManager.serviceClient().getApiGateways().createOrUpdate(this.resourceGroupName, this.gatewayName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ApiManagementGatewayResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiGateways().createOrUpdate(this.resourceGroupName, this.gatewayName, this.innerModel(), context);
        return this;
    }

    ApiManagementGatewayResourceImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ApiManagementGatewayResourceInner();
        this.serviceManager = serviceManager;
        this.gatewayName = name;
    }

    @Override
    public ApiManagementGatewayResourceImpl update() {
        this.updateParameters = new ApiManagementGatewayUpdateParameters();
        return this;
    }

    @Override
    public ApiManagementGatewayResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiGateways().update(this.resourceGroupName, this.gatewayName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public ApiManagementGatewayResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiGateways().update(this.resourceGroupName, this.gatewayName, this.updateParameters, context);
        return this;
    }

    ApiManagementGatewayResourceImpl(ApiManagementGatewayResourceInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.gatewayName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
    }

    @Override
    public ApiManagementGatewayResource refresh() {
        this.innerObject = (ApiManagementGatewayResourceInner)((Object)this.serviceManager.serviceClient().getApiGateways().getByResourceGroupWithResponse(this.resourceGroupName, this.gatewayName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ApiManagementGatewayResource refresh(Context context) {
        this.innerObject = (ApiManagementGatewayResourceInner)((Object)this.serviceManager.serviceClient().getApiGateways().getByResourceGroupWithResponse(this.resourceGroupName, this.gatewayName, context).getValue());
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withSku(ApiManagementGatewaySkuProperties sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags((Map)tags);
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withFrontend(FrontendConfiguration frontend) {
        if (this.isInCreateMode()) {
            this.innerModel().withFrontend(frontend);
            return this;
        }
        this.updateParameters.withFrontend(frontend);
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withBackend(BackendConfiguration backend) {
        if (this.isInCreateMode()) {
            this.innerModel().withBackend(backend);
            return this;
        }
        this.updateParameters.withBackend(backend);
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withConfigurationApi(GatewayConfigurationApi configurationApi) {
        if (this.isInCreateMode()) {
            this.innerModel().withConfigurationApi(configurationApi);
            return this;
        }
        this.updateParameters.withConfigurationApi(configurationApi);
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.isInCreateMode()) {
            this.innerModel().withVirtualNetworkType(virtualNetworkType);
            return this;
        }
        this.updateParameters.withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public ApiManagementGatewayResourceImpl withSku(ApiManagementGatewaySkuPropertiesForPatch sku) {
        this.updateParameters.withSku(sku);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

