/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementServiceSkusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ResourceSkuResultInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.ResourceSkuResultImpl;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkus;
import com.azure.resourcemanager.apimanagement.models.ResourceSkuResult;

public final class ApiManagementServiceSkusImpl
implements ApiManagementServiceSkus {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceSkusImpl.class);
    private final ApiManagementServiceSkusClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiManagementServiceSkusImpl(ApiManagementServiceSkusClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ResourceSkuResult> listAvailableServiceSkus(String resourceGroupName, String serviceName) {
        PagedIterable<ResourceSkuResultInner> inner = this.serviceClient().listAvailableServiceSkus(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceSkuResultImpl((ResourceSkuResultInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ResourceSkuResult> listAvailableServiceSkus(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<ResourceSkuResultInner> inner = this.serviceClient().listAvailableServiceSkus(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceSkuResultImpl((ResourceSkuResultInner)inner1, this.manager()));
    }

    private ApiManagementServiceSkusClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

