/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementSkusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementSkuInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementSkuImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSku;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkus;

public final class ApiManagementSkusImpl
implements ApiManagementSkus {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementSkusImpl.class);
    private final ApiManagementSkusClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiManagementSkusImpl(ApiManagementSkusClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiManagementSku> list() {
        PagedIterable<ApiManagementSkuInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementSkuImpl((ApiManagementSkuInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementSku> list(Context context) {
        PagedIterable<ApiManagementSkuInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementSkuImpl((ApiManagementSkuInner)inner1, this.manager()));
    }

    private ApiManagementSkusClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

