/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementWorkspaceLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementWorkspaceLinksResourceInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementWorkspaceLinksResourceImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinks;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinksResource;

public final class ApiManagementWorkspaceLinksImpl
implements ApiManagementWorkspaceLinks {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementWorkspaceLinksImpl.class);
    private final ApiManagementWorkspaceLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiManagementWorkspaceLinksImpl(ApiManagementWorkspaceLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiManagementWorkspaceLinksResource> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<ApiManagementWorkspaceLinksResourceInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementWorkspaceLinksResourceImpl((ApiManagementWorkspaceLinksResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementWorkspaceLinksResource> listByService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<ApiManagementWorkspaceLinksResourceInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementWorkspaceLinksResourceImpl((ApiManagementWorkspaceLinksResourceInner)((Object)inner1), this.manager()));
    }

    private ApiManagementWorkspaceLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

