/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.ApiOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsGetResponse;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.OperationCollection;
import com.azure.resourcemanager.apimanagement.models.OperationUpdateContract;
import reactor.core.publisher.Mono;

public final class ApiOperationsClientImpl
implements ApiOperationsClient {
    private final ApiOperationsService service;
    private final ApiManagementClientImpl client;

    ApiOperationsClientImpl(ApiManagementClientImpl client) {
        this.service = (ApiOperationsService)RestProxy.create(ApiOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationContractInner>> listByApiSinglePageAsync(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, String tags) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByApi(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, filter, top, skip, tags, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationCollection)res.getValue()).value(), ((OperationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationContractInner>> listByApiSinglePageAsync(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, String tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByApi(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, filter, top, skip, tags, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationCollection)res.getValue()).value(), ((OperationCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OperationContractInner> listByApiAsync(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, String tags) {
        return new PagedFlux(() -> this.listByApiSinglePageAsync(resourceGroupName, serviceName, apiId, filter, top, skip, tags), nextLink -> this.listByApiNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OperationContractInner> listByApiAsync(String resourceGroupName, String serviceName, String apiId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String tags = null;
        return new PagedFlux(() -> this.listByApiSinglePageAsync(resourceGroupName, serviceName, apiId, filter, top, skip, tags), nextLink -> this.listByApiNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OperationContractInner> listByApiAsync(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, String tags, Context context) {
        return new PagedFlux(() -> this.listByApiSinglePageAsync(resourceGroupName, serviceName, apiId, filter, top, skip, tags, context), nextLink -> this.listByApiNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationContractInner> listByApi(String resourceGroupName, String serviceName, String apiId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String tags = null;
        return new PagedIterable(this.listByApiAsync(resourceGroupName, serviceName, apiId, filter, top, skip, tags));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationContractInner> listByApi(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, String tags, Context context) {
        return new PagedIterable(this.listByApiAsync(resourceGroupName, serviceName, apiId, filter, top, skip, tags, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getEntityTagAsync(String resourceGroupName, String serviceName, String apiId, String operationId) {
        return this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, apiId, operationId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiOperationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, Context context) {
        return (ApiOperationsGetEntityTagResponse)((Object)this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String operationId) {
        this.getEntityTagWithResponse(resourceGroupName, serviceName, apiId, operationId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationContractInner> getAsync(String resourceGroupName, String serviceName, String apiId, String operationId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, apiId, operationId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiOperationsGetResponse getWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, Context context) {
        return (ApiOperationsGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationContractInner get(String resourceGroupName, String serviceName, String apiId, String operationId) {
        return this.getWithResponse(resourceGroupName, serviceName, apiId, operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, OperationContractInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, OperationContractInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String apiId, String operationId, OperationContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiOperationsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, OperationContractInner parameters, String ifMatch, Context context) {
        return (ApiOperationsCreateOrUpdateResponse)((Object)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, parameters, ifMatch, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationContractInner createOrUpdate(String resourceGroupName, String serviceName, String apiId, String operationId, OperationContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, operationId, parameters, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsUpdateResponse> updateWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiOperationsUpdateResponse> updateWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationContractInner> updateAsync(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters) {
        return this.updateWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, ifMatch, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiOperationsUpdateResponse updateWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters, Context context) {
        return (ApiOperationsUpdateResponse)((Object)this.updateWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, ifMatch, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationContractInner update(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters) {
        return this.updateWithResponse(resourceGroupName, serviceName, apiId, operationId, ifMatch, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, operationId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, apiId, operationId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch) {
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationContractInner>> listByApiNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByApiNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationCollection)res.getValue()).value(), ((OperationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationContractInner>> listByApiNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByApiNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationCollection)res.getValue()).value(), ((OperationCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientA")
    public static interface ApiOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationCollection>> listByApi(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skip") Integer var7, @QueryParam(value="tags") String var8, @QueryParam(value="api-version") String var9, @PathParam(value="subscriptionId") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ApiOperationsGetEntityTagResponse> getEntityTag(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="operationId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ApiOperationsGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="operationId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ApiOperationsCreateOrUpdateResponse> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="operationId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") OperationContractInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ApiOperationsUpdateResponse> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="operationId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") OperationUpdateContract var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="operationId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationCollection>> listByApiNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

