/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyCollectionImpl;
import com.azure.resourcemanager.apimanagement.implementation.PolicyContractImpl;
import com.azure.resourcemanager.apimanagement.models.ApiPolicies;
import com.azure.resourcemanager.apimanagement.models.ApiPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.ApiPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyCollection;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;

public final class ApiPoliciesImpl
implements ApiPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(ApiPoliciesImpl.class);
    private final ApiPoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiPoliciesImpl(ApiPoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PolicyCollection> listByApiWithResponse(String resourceGroupName, String serviceName, String apiId, Context context) {
        Response<PolicyCollectionInner> inner = this.serviceClient().listByApiWithResponse(resourceGroupName, serviceName, apiId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyCollectionImpl((PolicyCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyCollection listByApi(String resourceGroupName, String serviceName, String apiId) {
        PolicyCollectionInner inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        if (inner != null) {
            return new PolicyCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, policyId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, policyId);
    }

    @Override
    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        ApiPoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract get(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        ApiPoliciesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, apiId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, policyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, policyId, ifMatch);
    }

    private ApiPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

