/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiProductsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ProductContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiProducts;
import com.azure.resourcemanager.apimanagement.models.ProductContract;

public final class ApiProductsImpl
implements ApiProducts {
    private static final ClientLogger LOGGER = new ClientLogger(ApiProductsImpl.class);
    private final ApiProductsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiProductsImpl(ApiProductsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProductContract> listByApis(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<ProductContractInner> inner = this.serviceClient().listByApis(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductContractImpl((ProductContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProductContract> listByApis(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductContractInner> inner = this.serviceClient().listByApis(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductContractImpl((ProductContractInner)((Object)inner1), this.manager()));
    }

    private ApiProductsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

