/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiReleaseContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiReleaseContract;
import java.time.OffsetDateTime;

public final class ApiReleaseContractImpl
implements ApiReleaseContract,
ApiReleaseContract.Definition,
ApiReleaseContract.Update {
    private ApiReleaseContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String releaseId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String apiId() {
        return this.innerModel().apiId();
    }

    @Override
    public OffsetDateTime createdDateTime() {
        return this.innerModel().createdDateTime();
    }

    @Override
    public OffsetDateTime updatedDateTime() {
        return this.innerModel().updatedDateTime();
    }

    @Override
    public String notes() {
        return this.innerModel().notes();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiReleaseContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiReleaseContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    @Override
    public ApiReleaseContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiReleases().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.releaseId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiReleaseContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiReleases().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.releaseId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    ApiReleaseContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ApiReleaseContractInner();
        this.serviceManager = serviceManager;
        this.releaseId = name;
        this.createIfMatch = null;
    }

    @Override
    public ApiReleaseContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ApiReleaseContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiReleases().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.releaseId, this.updateIfMatch, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiReleaseContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiReleases().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.releaseId, this.updateIfMatch, this.innerModel(), context).getValue();
        return this;
    }

    ApiReleaseContractImpl(ApiReleaseContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.releaseId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "releases");
    }

    @Override
    public ApiReleaseContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiReleases().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.releaseId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiReleaseContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiReleases().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.releaseId, context).getValue();
        return this;
    }

    @Override
    public ApiReleaseContractImpl withApiId(String apiId) {
        this.innerModel().withApiId(apiId);
        return this;
    }

    @Override
    public ApiReleaseContractImpl withNotes(String notes) {
        this.innerModel().withNotes(notes);
        return this;
    }

    @Override
    public ApiReleaseContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

