/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiReleasesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiReleaseContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiReleaseContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiReleaseContract;
import com.azure.resourcemanager.apimanagement.models.ApiReleases;
import com.azure.resourcemanager.apimanagement.models.ApiReleasesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiReleasesGetResponse;

public final class ApiReleasesImpl
implements ApiReleases {
    private static final ClientLogger LOGGER = new ClientLogger(ApiReleasesImpl.class);
    private final ApiReleasesClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiReleasesImpl(ApiReleasesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiReleaseContract> listByService(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<ApiReleaseContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiReleaseContractImpl((ApiReleaseContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiReleaseContract> listByService(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ApiReleaseContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiReleaseContractImpl((ApiReleaseContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiReleasesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String releaseId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, releaseId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String releaseId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, releaseId);
    }

    @Override
    public Response<ApiReleaseContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String releaseId, Context context) {
        ApiReleasesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, releaseId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiReleaseContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiReleaseContract get(String resourceGroupName, String serviceName, String apiId, String releaseId) {
        ApiReleaseContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, releaseId);
        if (inner != null) {
            return new ApiReleaseContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String releaseId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, releaseId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String releaseId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, releaseId, ifMatch);
    }

    @Override
    public ApiReleaseContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        return (ApiReleaseContract)this.getWithResponse(resourceGroupName, serviceName, apiId, releaseId, Context.NONE).getValue();
    }

    @Override
    public Response<ApiReleaseContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, releaseId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, releaseId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, releaseId, ifMatch, context);
    }

    private ApiReleasesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiReleaseContractImpl define(String name) {
        return new ApiReleaseContractImpl(name, this.manager());
    }
}

