/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiSchemasClient;
import com.azure.resourcemanager.apimanagement.fluent.models.SchemaContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.SchemaContractImpl;
import com.azure.resourcemanager.apimanagement.models.ApiSchemas;
import com.azure.resourcemanager.apimanagement.models.ApiSchemasGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiSchemasGetResponse;
import com.azure.resourcemanager.apimanagement.models.SchemaContract;

public final class ApiSchemasImpl
implements ApiSchemas {
    private static final ClientLogger LOGGER = new ClientLogger(ApiSchemasImpl.class);
    private final ApiSchemasClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiSchemasImpl(ApiSchemasClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SchemaContract> listByApi(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<SchemaContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaContractImpl((SchemaContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SchemaContract> listByApi(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<SchemaContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaContractImpl((SchemaContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiSchemasGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String schemaId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, schemaId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String schemaId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, schemaId);
    }

    @Override
    public Response<SchemaContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String schemaId, Context context) {
        ApiSchemasGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, schemaId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SchemaContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SchemaContract get(String resourceGroupName, String serviceName, String apiId, String schemaId) {
        SchemaContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, schemaId);
        if (inner != null) {
            return new SchemaContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String schemaId, String ifMatch, Boolean force, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, schemaId, ifMatch, force, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String schemaId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, schemaId, ifMatch);
    }

    @Override
    public SchemaContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return (SchemaContract)this.getWithResponse(resourceGroupName, serviceName, apiId, schemaId, Context.NONE).getValue();
    }

    @Override
    public Response<SchemaContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, schemaId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String localIfMatch = null;
        Boolean localForce = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, schemaId, localIfMatch, localForce, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Boolean force, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, schemaId, ifMatch, force, context);
    }

    private ApiSchemasClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchemaContractImpl define(String name) {
        return new SchemaContractImpl(name, this.manager());
    }
}

