/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiTagDescriptionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagDescriptionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagDescriptionContractImpl;
import com.azure.resourcemanager.apimanagement.models.ApiTagDescriptions;
import com.azure.resourcemanager.apimanagement.models.ApiTagDescriptionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiTagDescriptionsGetResponse;
import com.azure.resourcemanager.apimanagement.models.TagDescriptionContract;

public final class ApiTagDescriptionsImpl
implements ApiTagDescriptions {
    private static final ClientLogger LOGGER = new ClientLogger(ApiTagDescriptionsImpl.class);
    private final ApiTagDescriptionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiTagDescriptionsImpl(ApiTagDescriptionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagDescriptionContract> listByService(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<TagDescriptionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagDescriptionContractImpl((TagDescriptionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagDescriptionContract> listByService(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagDescriptionContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagDescriptionContractImpl((TagDescriptionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiTagDescriptionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, tagDescriptionId);
    }

    @Override
    public Response<TagDescriptionContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId, Context context) {
        ApiTagDescriptionsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagDescriptionContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagDescriptionContract get(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId) {
        TagDescriptionContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, tagDescriptionId);
        if (inner != null) {
            return new TagDescriptionContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, tagDescriptionId, ifMatch);
    }

    @Override
    public TagDescriptionContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        return (TagDescriptionContract)this.getWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, Context.NONE).getValue();
    }

    @Override
    public Response<TagDescriptionContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, ifMatch, context);
    }

    private ApiTagDescriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagDescriptionContractImpl define(String name) {
        return new TagDescriptionContractImpl(name, this.manager());
    }
}

