/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationAccessPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationAccessPolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPolicyCollection;
import reactor.core.publisher.Mono;

public final class AuthorizationAccessPoliciesClientImpl
implements AuthorizationAccessPoliciesClient {
    private final AuthorizationAccessPoliciesService service;
    private final ApiManagementClientImpl client;

    AuthorizationAccessPoliciesClientImpl(ApiManagementClientImpl client) {
        this.service = (AuthorizationAccessPoliciesService)RestProxy.create(AuthorizationAccessPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>> listByAuthorizationSinglePageAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAuthorization(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationAccessPolicyCollection)res.getValue()).value(), ((AuthorizationAccessPolicyCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>> listByAuthorizationSinglePageAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAuthorization(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationAccessPolicyCollection)res.getValue()).value(), ((AuthorizationAccessPolicyCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AuthorizationAccessPolicyContractInner> listByAuthorizationAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top, Integer skip) {
        return new PagedFlux(() -> this.listByAuthorizationSinglePageAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip), nextLink -> this.listByAuthorizationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AuthorizationAccessPolicyContractInner> listByAuthorizationAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listByAuthorizationSinglePageAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip), nextLink -> this.listByAuthorizationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AuthorizationAccessPolicyContractInner> listByAuthorizationAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux(() -> this.listByAuthorizationSinglePageAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip, context), nextLink -> this.listByAuthorizationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AuthorizationAccessPolicyContractInner> listByAuthorization(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedIterable(this.listByAuthorizationAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AuthorizationAccessPolicyContractInner> listByAuthorization(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable(this.listByAuthorizationAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationAccessPolicyContractInner> getAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationAccessPoliciesGetResponse getWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, Context context) {
        return (AuthorizationAccessPoliciesGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationAccessPolicyContractInner get(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId) {
        return this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, AuthorizationAccessPolicyContractInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, AuthorizationAccessPolicyContractInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationAccessPolicyContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, AuthorizationAccessPolicyContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationAccessPoliciesCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, AuthorizationAccessPolicyContractInner parameters, String ifMatch, Context context) {
        return (AuthorizationAccessPoliciesCreateOrUpdateResponse)((Object)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, parameters, ifMatch, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationAccessPolicyContractInner createOrUpdate(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, AuthorizationAccessPolicyContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, parameters, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch) {
        this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>> listByAuthorizationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAuthorizationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationAccessPolicyCollection)res.getValue()).value(), ((AuthorizationAccessPolicyCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>> listByAuthorizationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAuthorizationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationAccessPolicyCollection)res.getValue()).value(), ((AuthorizationAccessPolicyCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientA")
    public static interface AuthorizationAccessPoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthorizationAccessPolicyCollection>> listByAuthorization(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @PathParam(value="authorizationId") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$skip") Integer var8, @QueryParam(value="api-version") String var9, @PathParam(value="subscriptionId") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<AuthorizationAccessPoliciesGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @PathParam(value="authorizationId") String var5, @PathParam(value="authorizationAccessPolicyId") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<AuthorizationAccessPoliciesCreateOrUpdateResponse> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @PathParam(value="authorizationId") String var5, @PathParam(value="authorizationAccessPolicyId") String var6, @HeaderParam(value="If-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @BodyParam(value="application/json") AuthorizationAccessPolicyContractInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @PathParam(value="authorizationId") String var5, @PathParam(value="authorizationAccessPolicyId") String var6, @HeaderParam(value="If-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthorizationAccessPolicyCollection>> listByAuthorizationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

