/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationLoginLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationLoginResponseContractInner;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationLoginResponseContractImpl;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginLinks;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginLinksPostResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginResponseContract;

public final class AuthorizationLoginLinksImpl
implements AuthorizationLoginLinks {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationLoginLinksImpl.class);
    private final AuthorizationLoginLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public AuthorizationLoginLinksImpl(AuthorizationLoginLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AuthorizationLoginResponseContract> postWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters, Context context) {
        AuthorizationLoginLinksPostResponse inner = this.serviceClient().postWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthorizationLoginResponseContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AuthorizationLoginResponseContract post(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters) {
        AuthorizationLoginResponseContractInner inner = this.serviceClient().post(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters);
        if (inner != null) {
            return new AuthorizationLoginResponseContractImpl(inner, this.manager());
        }
        return null;
    }

    private AuthorizationLoginLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

