/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationProvidersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationProviderContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviderCollection;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProvidersCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProvidersGetResponse;
import reactor.core.publisher.Mono;

public final class AuthorizationProvidersClientImpl
implements AuthorizationProvidersClient {
    private final AuthorizationProvidersService service;
    private final ApiManagementClientImpl client;

    AuthorizationProvidersClientImpl(ApiManagementClientImpl client) {
        this.service = (AuthorizationProvidersService)RestProxy.create(AuthorizationProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationProviderContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationProviderCollection)res.getValue()).value(), ((AuthorizationProviderCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationProviderContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationProviderCollection)res.getValue()).value(), ((AuthorizationProviderCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AuthorizationProviderContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AuthorizationProviderContractInner> listByServiceAsync(String resourceGroupName, String serviceName) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AuthorizationProviderContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, context), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AuthorizationProviderContractInner> listByService(String resourceGroupName, String serviceName) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, filter, top, skip));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AuthorizationProviderContractInner> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, filter, top, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationProvidersGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationProvidersGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationProviderContractInner> getAsync(String resourceGroupName, String serviceName, String authorizationProviderId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationProvidersGetResponse getWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, Context context) {
        return (AuthorizationProvidersGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationProviderContractInner get(String resourceGroupName, String serviceName, String authorizationProviderId) {
        return this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationProvidersCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, AuthorizationProviderContractInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationProvidersCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, AuthorizationProviderContractInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationProviderContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String authorizationProviderId, AuthorizationProviderContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationProvidersCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, AuthorizationProviderContractInner parameters, String ifMatch, Context context) {
        return (AuthorizationProvidersCreateOrUpdateResponse)((Object)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, parameters, ifMatch, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationProviderContractInner createOrUpdate(String resourceGroupName, String serviceName, String authorizationProviderId, AuthorizationProviderContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, parameters, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String authorizationProviderId, String ifMatch) {
        this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationProviderContractInner>> listByServiceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationProviderCollection)res.getValue()).value(), ((AuthorizationProviderCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationProviderContractInner>> listByServiceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizationProviderCollection)res.getValue()).value(), ((AuthorizationProviderCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientA")
    public static interface AuthorizationProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthorizationProviderCollection>> listByService(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skip") Integer var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<AuthorizationProvidersGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<AuthorizationProvidersCreateOrUpdateResponse> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") AuthorizationProviderContractInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthorizationProviderCollection>> listByServiceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

