/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationProvidersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationProviderContractInner;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationProviderContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviderContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviders;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProvidersGetResponse;

public final class AuthorizationProvidersImpl
implements AuthorizationProviders {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationProvidersImpl.class);
    private final AuthorizationProvidersClient innerClient;
    private final ApiManagementManager serviceManager;

    public AuthorizationProvidersImpl(AuthorizationProvidersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AuthorizationProviderContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<AuthorizationProviderContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationProviderContractImpl((AuthorizationProviderContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AuthorizationProviderContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<AuthorizationProviderContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationProviderContractImpl((AuthorizationProviderContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AuthorizationProviderContract> getWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, Context context) {
        AuthorizationProvidersGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, authorizationProviderId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthorizationProviderContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AuthorizationProviderContract get(String resourceGroupName, String serviceName, String authorizationProviderId) {
        AuthorizationProviderContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, authorizationProviderId);
        if (inner != null) {
            return new AuthorizationProviderContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String authorizationProviderId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, authorizationProviderId, ifMatch);
    }

    @Override
    public AuthorizationProviderContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        return (AuthorizationProviderContract)this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, Context.NONE).getValue();
    }

    @Override
    public Response<AuthorizationProviderContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, ifMatch, context);
    }

    private AuthorizationProvidersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationProviderContractImpl define(String name) {
        return new AuthorizationProviderContractImpl(name, this.manager());
    }
}

