/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationServersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationServerContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationServerSecretsContractInner;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationServerContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationServerSecretsContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerSecretsContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServers;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServersGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServersGetResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServersListSecretsResponse;

public final class AuthorizationServersImpl
implements AuthorizationServers {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationServersImpl.class);
    private final AuthorizationServersClient innerClient;
    private final ApiManagementManager serviceManager;

    public AuthorizationServersImpl(AuthorizationServersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AuthorizationServerContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<AuthorizationServerContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationServerContractImpl((AuthorizationServerContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AuthorizationServerContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<AuthorizationServerContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationServerContractImpl((AuthorizationServerContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public AuthorizationServersGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String authsid, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, authsid, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String authsid) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, authsid);
    }

    @Override
    public Response<AuthorizationServerContract> getWithResponse(String resourceGroupName, String serviceName, String authsid, Context context) {
        AuthorizationServersGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, authsid, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthorizationServerContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AuthorizationServerContract get(String resourceGroupName, String serviceName, String authsid) {
        AuthorizationServerContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, authsid);
        if (inner != null) {
            return new AuthorizationServerContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authsid, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, authsid, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String authsid, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, authsid, ifMatch);
    }

    @Override
    public Response<AuthorizationServerSecretsContract> listSecretsWithResponse(String resourceGroupName, String serviceName, String authsid, Context context) {
        AuthorizationServersListSecretsResponse inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, serviceName, authsid, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthorizationServerSecretsContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AuthorizationServerSecretsContract listSecrets(String resourceGroupName, String serviceName, String authsid) {
        AuthorizationServerSecretsContractInner inner = this.serviceClient().listSecrets(resourceGroupName, serviceName, authsid);
        if (inner != null) {
            return new AuthorizationServerSecretsContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AuthorizationServerContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        return (AuthorizationServerContract)this.getWithResponse(resourceGroupName, serviceName, authsid, Context.NONE).getValue();
    }

    @Override
    public Response<AuthorizationServerContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, authsid, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, authsid, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, authsid, ifMatch, context);
    }

    private AuthorizationServersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationServerContractImpl define(String name) {
        return new AuthorizationServerContractImpl(name, this.manager());
    }
}

