/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationConfirmConsentCodeRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationContract;
import com.azure.resourcemanager.apimanagement.models.Authorizations;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsConfirmConsentCodeResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsGetResponse;

public final class AuthorizationsImpl
implements Authorizations {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationsImpl.class);
    private final AuthorizationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public AuthorizationsImpl(AuthorizationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AuthorizationContract> listByAuthorizationProvider(String resourceGroupName, String serviceName, String authorizationProviderId) {
        PagedIterable<AuthorizationContractInner> inner = this.serviceClient().listByAuthorizationProvider(resourceGroupName, serviceName, authorizationProviderId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationContractImpl((AuthorizationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AuthorizationContract> listByAuthorizationProvider(String resourceGroupName, String serviceName, String authorizationProviderId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<AuthorizationContractInner> inner = this.serviceClient().listByAuthorizationProvider(resourceGroupName, serviceName, authorizationProviderId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationContractImpl((AuthorizationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AuthorizationContract> getWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, Context context) {
        AuthorizationsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthorizationContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AuthorizationContract get(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId) {
        AuthorizationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, authorizationProviderId, authorizationId);
        if (inner != null) {
            return new AuthorizationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, authorizationProviderId, authorizationId, ifMatch);
    }

    @Override
    public AuthorizationsConfirmConsentCodeResponse confirmConsentCodeWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationConfirmConsentCodeRequestContract parameters, Context context) {
        return this.serviceClient().confirmConsentCodeWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters, context);
    }

    @Override
    public void confirmConsentCode(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationConfirmConsentCodeRequestContract parameters) {
        this.serviceClient().confirmConsentCode(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters);
    }

    @Override
    public AuthorizationContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        return (AuthorizationContract)this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, Context.NONE).getValue();
    }

    @Override
    public Response<AuthorizationContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, ifMatch, context);
    }

    private AuthorizationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationContractImpl define(String name) {
        return new AuthorizationContractImpl(name, this.manager());
    }
}

