/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.CacheContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.CacheContract;
import com.azure.resourcemanager.apimanagement.models.CacheUpdateParameters;

public final class CacheContractImpl
implements CacheContract,
CacheContract.Definition,
CacheContract.Update {
    private CacheContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String cacheId;
    private String createIfMatch;
    private String updateIfMatch;
    private CacheUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String connectionString() {
        return this.innerModel().connectionString();
    }

    @Override
    public String useFromLocation() {
        return this.innerModel().useFromLocation();
    }

    @Override
    public String resourceId() {
        return this.innerModel().resourceId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CacheContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public CacheContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public CacheContract create() {
        this.innerObject = this.serviceManager.serviceClient().getCaches().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.cacheId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public CacheContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaches().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.cacheId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    CacheContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new CacheContractInner();
        this.serviceManager = serviceManager;
        this.cacheId = name;
        this.createIfMatch = null;
    }

    @Override
    public CacheContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new CacheUpdateParameters();
        return this;
    }

    @Override
    public CacheContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getCaches().updateWithResponse(this.resourceGroupName, this.serviceName, this.cacheId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public CacheContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaches().updateWithResponse(this.resourceGroupName, this.serviceName, this.cacheId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    CacheContractImpl(CacheContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.cacheId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "caches");
    }

    @Override
    public CacheContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getCaches().getWithResponse(this.resourceGroupName, this.serviceName, this.cacheId, Context.NONE).getValue();
        return this;
    }

    @Override
    public CacheContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaches().getWithResponse(this.resourceGroupName, this.serviceName, this.cacheId, context).getValue();
        return this;
    }

    @Override
    public CacheContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public CacheContractImpl withConnectionString(String connectionString) {
        if (this.isInCreateMode()) {
            this.innerModel().withConnectionString(connectionString);
            return this;
        }
        this.updateParameters.withConnectionString(connectionString);
        return this;
    }

    @Override
    public CacheContractImpl withUseFromLocation(String useFromLocation) {
        if (this.isInCreateMode()) {
            this.innerModel().withUseFromLocation(useFromLocation);
            return this;
        }
        this.updateParameters.withUseFromLocation(useFromLocation);
        return this;
    }

    @Override
    public CacheContractImpl withResourceId(String resourceId) {
        if (this.isInCreateMode()) {
            this.innerModel().withResourceId(resourceId);
            return this;
        }
        this.updateParameters.withResourceId(resourceId);
        return this;
    }

    @Override
    public CacheContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

