/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.CachesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.CacheContractInner;
import com.azure.resourcemanager.apimanagement.implementation.CacheContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.CacheContract;
import com.azure.resourcemanager.apimanagement.models.Caches;
import com.azure.resourcemanager.apimanagement.models.CachesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.CachesGetResponse;

public final class CachesImpl
implements Caches {
    private static final ClientLogger LOGGER = new ClientLogger(CachesImpl.class);
    private final CachesClient innerClient;
    private final ApiManagementManager serviceManager;

    public CachesImpl(CachesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CacheContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<CacheContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheContractImpl((CacheContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CacheContract> listByService(String resourceGroupName, String serviceName, Integer top, Integer skip, Context context) {
        PagedIterable<CacheContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheContractImpl((CacheContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public CachesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String cacheId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, cacheId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String cacheId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, cacheId);
    }

    @Override
    public Response<CacheContract> getWithResponse(String resourceGroupName, String serviceName, String cacheId, Context context) {
        CachesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, cacheId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CacheContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CacheContract get(String resourceGroupName, String serviceName, String cacheId) {
        CacheContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, cacheId);
        if (inner != null) {
            return new CacheContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String cacheId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, cacheId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String cacheId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, cacheId, ifMatch);
    }

    @Override
    public CacheContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return (CacheContract)this.getWithResponse(resourceGroupName, serviceName, cacheId, Context.NONE).getValue();
    }

    @Override
    public Response<CacheContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, cacheId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, cacheId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, cacheId, ifMatch, context);
    }

    private CachesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public CacheContractImpl define(String name) {
        return new CacheContractImpl(name, this.manager());
    }
}

