/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentItemContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ContentItemContract;
import java.util.Collections;
import java.util.Map;

public final class ContentItemContractImpl
implements ContentItemContract,
ContentItemContract.Definition,
ContentItemContract.Update {
    private ContentItemContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String contentTypeId;
    private String contentItemId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Map<String, Object> properties() {
        Map<String, Object> inner = this.innerModel().properties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ContentItemContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContentItemContractImpl withExistingContentType(String resourceGroupName, String serviceName, String contentTypeId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.contentTypeId = contentTypeId;
        return this;
    }

    @Override
    public ContentItemContract create() {
        this.innerObject = this.serviceManager.serviceClient().getContentItems().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.contentItemId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ContentItemContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContentItems().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.contentItemId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    ContentItemContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ContentItemContractInner();
        this.serviceManager = serviceManager;
        this.contentItemId = name;
        this.createIfMatch = null;
    }

    @Override
    public ContentItemContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ContentItemContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getContentItems().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.contentItemId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ContentItemContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContentItems().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.contentItemId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    ContentItemContractImpl(ContentItemContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.contentTypeId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contentTypes");
        this.contentItemId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contentItems");
    }

    @Override
    public ContentItemContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getContentItems().getWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.contentItemId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ContentItemContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContentItems().getWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.contentItemId, context).getValue();
        return this;
    }

    @Override
    public ContentItemContractImpl withProperties(Map<String, Object> properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ContentItemContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

