/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentTypeContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ContentTypeContract;

public final class ContentTypeContractImpl
implements ContentTypeContract,
ContentTypeContract.Definition,
ContentTypeContract.Update {
    private ContentTypeContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String contentTypeId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String idPropertiesId() {
        return this.innerModel().idPropertiesId();
    }

    @Override
    public String namePropertiesName() {
        return this.innerModel().namePropertiesName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Object schema() {
        return this.innerModel().schema();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ContentTypeContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContentTypeContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public ContentTypeContract create() {
        this.innerObject = this.serviceManager.serviceClient().getContentTypes().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ContentTypeContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContentTypes().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    ContentTypeContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ContentTypeContractInner();
        this.serviceManager = serviceManager;
        this.contentTypeId = name;
        this.createIfMatch = null;
    }

    @Override
    public ContentTypeContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ContentTypeContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getContentTypes().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ContentTypeContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContentTypes().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    ContentTypeContractImpl(ContentTypeContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.contentTypeId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contentTypes");
    }

    @Override
    public ContentTypeContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getContentTypes().getWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ContentTypeContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContentTypes().getWithResponse(this.resourceGroupName, this.serviceName, this.contentTypeId, context).getValue();
        return this;
    }

    @Override
    public ContentTypeContractImpl withIdPropertiesId(String idPropertiesId) {
        this.innerModel().withIdPropertiesId(idPropertiesId);
        return this;
    }

    @Override
    public ContentTypeContractImpl withNamePropertiesName(String namePropertiesName) {
        this.innerModel().withNamePropertiesName(namePropertiesName);
        return this;
    }

    @Override
    public ContentTypeContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public ContentTypeContractImpl withSchema(Object schema) {
        this.innerModel().withSchema(schema);
        return this;
    }

    @Override
    public ContentTypeContractImpl withVersion(String version) {
        this.innerModel().withVersion(version);
        return this;
    }

    @Override
    public ContentTypeContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

