/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ContentTypesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentTypeContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ContentTypeContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ContentTypeContract;
import com.azure.resourcemanager.apimanagement.models.ContentTypes;
import com.azure.resourcemanager.apimanagement.models.ContentTypesGetResponse;

public final class ContentTypesImpl
implements ContentTypes {
    private static final ClientLogger LOGGER = new ClientLogger(ContentTypesImpl.class);
    private final ContentTypesClient innerClient;
    private final ApiManagementManager serviceManager;

    public ContentTypesImpl(ContentTypesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ContentTypeContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<ContentTypeContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContentTypeContractImpl((ContentTypeContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContentTypeContract> listByService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<ContentTypeContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContentTypeContractImpl((ContentTypeContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ContentTypeContract> getWithResponse(String resourceGroupName, String serviceName, String contentTypeId, Context context) {
        ContentTypesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, contentTypeId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ContentTypeContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ContentTypeContract get(String resourceGroupName, String serviceName, String contentTypeId) {
        ContentTypeContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, contentTypeId);
        if (inner != null) {
            return new ContentTypeContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String contentTypeId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, contentTypeId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String contentTypeId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, contentTypeId, ifMatch);
    }

    @Override
    public ContentTypeContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        return (ContentTypeContract)this.getWithResponse(resourceGroupName, serviceName, contentTypeId, Context.NONE).getValue();
    }

    @Override
    public Response<ContentTypeContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, contentTypeId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, contentTypeId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, contentTypeId, ifMatch, context);
    }

    private ContentTypesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContentTypeContractImpl define(String name) {
        return new ContentTypeContractImpl(name, this.manager());
    }
}

