/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.DeletedServicesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.DeletedServiceContractInner;
import com.azure.resourcemanager.apimanagement.implementation.DeletedServiceContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.DeletedServiceContract;
import com.azure.resourcemanager.apimanagement.models.DeletedServices;

public final class DeletedServicesImpl
implements DeletedServices {
    private static final ClientLogger LOGGER = new ClientLogger(DeletedServicesImpl.class);
    private final DeletedServicesClient innerClient;
    private final ApiManagementManager serviceManager;

    public DeletedServicesImpl(DeletedServicesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DeletedServiceContract> list() {
        PagedIterable<DeletedServiceContractInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeletedServiceContractImpl((DeletedServiceContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeletedServiceContract> list(Context context) {
        PagedIterable<DeletedServiceContractInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeletedServiceContractImpl((DeletedServiceContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DeletedServiceContract> getByNameWithResponse(String serviceName, String location, Context context) {
        Response<DeletedServiceContractInner> inner = this.serviceClient().getByNameWithResponse(serviceName, location, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeletedServiceContractImpl((DeletedServiceContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DeletedServiceContract getByName(String serviceName, String location) {
        DeletedServiceContractInner inner = this.serviceClient().getByName(serviceName, location);
        if (inner != null) {
            return new DeletedServiceContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeletedServiceContract purge(String serviceName, String location) {
        DeletedServiceContractInner inner = this.serviceClient().purge(serviceName, location);
        if (inner != null) {
            return new DeletedServiceContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeletedServiceContract purge(String serviceName, String location, Context context) {
        DeletedServiceContractInner inner = this.serviceClient().purge(serviceName, location, context);
        if (inner != null) {
            return new DeletedServiceContractImpl(inner, this.manager());
        }
        return null;
    }

    private DeletedServicesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

