/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.DiagnosticContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AlwaysLog;
import com.azure.resourcemanager.apimanagement.models.DiagnosticContract;
import com.azure.resourcemanager.apimanagement.models.HttpCorrelationProtocol;
import com.azure.resourcemanager.apimanagement.models.OperationNameFormat;
import com.azure.resourcemanager.apimanagement.models.PipelineDiagnosticSettings;
import com.azure.resourcemanager.apimanagement.models.SamplingSettings;
import com.azure.resourcemanager.apimanagement.models.Verbosity;

public final class DiagnosticContractImpl
implements DiagnosticContract,
DiagnosticContract.Definition,
DiagnosticContract.Update {
    private DiagnosticContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String diagnosticId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public AlwaysLog alwaysLog() {
        return this.innerModel().alwaysLog();
    }

    @Override
    public String loggerId() {
        return this.innerModel().loggerId();
    }

    @Override
    public SamplingSettings sampling() {
        return this.innerModel().sampling();
    }

    @Override
    public PipelineDiagnosticSettings frontend() {
        return this.innerModel().frontend();
    }

    @Override
    public PipelineDiagnosticSettings backend() {
        return this.innerModel().backend();
    }

    @Override
    public Boolean logClientIp() {
        return this.innerModel().logClientIp();
    }

    @Override
    public HttpCorrelationProtocol httpCorrelationProtocol() {
        return this.innerModel().httpCorrelationProtocol();
    }

    @Override
    public Verbosity verbosity() {
        return this.innerModel().verbosity();
    }

    @Override
    public OperationNameFormat operationNameFormat() {
        return this.innerModel().operationNameFormat();
    }

    @Override
    public Boolean metrics() {
        return this.innerModel().metrics();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DiagnosticContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public DiagnosticContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    @Override
    public DiagnosticContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiDiagnostics().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.diagnosticId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public DiagnosticContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiDiagnostics().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.diagnosticId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    DiagnosticContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new DiagnosticContractInner();
        this.serviceManager = serviceManager;
        this.diagnosticId = name;
        this.createIfMatch = null;
    }

    @Override
    public DiagnosticContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public DiagnosticContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiDiagnostics().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.diagnosticId, this.updateIfMatch, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public DiagnosticContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiDiagnostics().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.diagnosticId, this.updateIfMatch, this.innerModel(), context).getValue();
        return this;
    }

    DiagnosticContractImpl(DiagnosticContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.diagnosticId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "diagnostics");
    }

    @Override
    public DiagnosticContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiDiagnostics().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.diagnosticId, Context.NONE).getValue();
        return this;
    }

    @Override
    public DiagnosticContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiDiagnostics().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.diagnosticId, context).getValue();
        return this;
    }

    @Override
    public DiagnosticContractImpl withAlwaysLog(AlwaysLog alwaysLog) {
        this.innerModel().withAlwaysLog(alwaysLog);
        return this;
    }

    @Override
    public DiagnosticContractImpl withLoggerId(String loggerId) {
        this.innerModel().withLoggerId(loggerId);
        return this;
    }

    @Override
    public DiagnosticContractImpl withSampling(SamplingSettings sampling) {
        this.innerModel().withSampling(sampling);
        return this;
    }

    @Override
    public DiagnosticContractImpl withFrontend(PipelineDiagnosticSettings frontend) {
        this.innerModel().withFrontend(frontend);
        return this;
    }

    @Override
    public DiagnosticContractImpl withBackend(PipelineDiagnosticSettings backend) {
        this.innerModel().withBackend(backend);
        return this;
    }

    @Override
    public DiagnosticContractImpl withLogClientIp(Boolean logClientIp) {
        this.innerModel().withLogClientIp(logClientIp);
        return this;
    }

    @Override
    public DiagnosticContractImpl withHttpCorrelationProtocol(HttpCorrelationProtocol httpCorrelationProtocol) {
        this.innerModel().withHttpCorrelationProtocol(httpCorrelationProtocol);
        return this;
    }

    @Override
    public DiagnosticContractImpl withVerbosity(Verbosity verbosity) {
        this.innerModel().withVerbosity(verbosity);
        return this;
    }

    @Override
    public DiagnosticContractImpl withOperationNameFormat(OperationNameFormat operationNameFormat) {
        this.innerModel().withOperationNameFormat(operationNameFormat);
        return this;
    }

    @Override
    public DiagnosticContractImpl withMetrics(Boolean metrics) {
        this.innerModel().withMetrics(metrics);
        return this;
    }

    @Override
    public DiagnosticContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

