/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayHostnameConfigurationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GatewayHostnameConfigurationContract;

public final class GatewayHostnameConfigurationContractImpl
implements GatewayHostnameConfigurationContract,
GatewayHostnameConfigurationContract.Definition,
GatewayHostnameConfigurationContract.Update {
    private GatewayHostnameConfigurationContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String gatewayId;
    private String hcId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String hostname() {
        return this.innerModel().hostname();
    }

    @Override
    public String certificateId() {
        return this.innerModel().certificateId();
    }

    @Override
    public Boolean negotiateClientCertificate() {
        return this.innerModel().negotiateClientCertificate();
    }

    @Override
    public Boolean tls10Enabled() {
        return this.innerModel().tls10Enabled();
    }

    @Override
    public Boolean tls11Enabled() {
        return this.innerModel().tls11Enabled();
    }

    @Override
    public Boolean http2Enabled() {
        return this.innerModel().http2Enabled();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GatewayHostnameConfigurationContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withExistingGateway(String resourceGroupName, String serviceName, String gatewayId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.gatewayId = gatewayId;
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContract create() {
        this.innerObject = this.serviceManager.serviceClient().getGatewayHostnameConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.hcId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGatewayHostnameConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.hcId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    GatewayHostnameConfigurationContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new GatewayHostnameConfigurationContractInner();
        this.serviceManager = serviceManager;
        this.hcId = name;
        this.createIfMatch = null;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getGatewayHostnameConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.hcId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGatewayHostnameConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.hcId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    GatewayHostnameConfigurationContractImpl(GatewayHostnameConfigurationContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.gatewayId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
        this.hcId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "hostnameConfigurations");
    }

    @Override
    public GatewayHostnameConfigurationContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getGatewayHostnameConfigurations().getWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.hcId, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGatewayHostnameConfigurations().getWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.hcId, context).getValue();
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withHostname(String hostname) {
        this.innerModel().withHostname(hostname);
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withCertificateId(String certificateId) {
        this.innerModel().withCertificateId(certificateId);
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withNegotiateClientCertificate(Boolean negotiateClientCertificate) {
        this.innerModel().withNegotiateClientCertificate(negotiateClientCertificate);
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withTls10Enabled(Boolean tls10Enabled) {
        this.innerModel().withTls10Enabled(tls10Enabled);
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withTls11Enabled(Boolean tls11Enabled) {
        this.innerModel().withTls11Enabled(tls11Enabled);
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withHttp2Enabled(Boolean http2Enabled) {
        this.innerModel().withHttp2Enabled(http2Enabled);
        return this;
    }

    @Override
    public GatewayHostnameConfigurationContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

