/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.GatewaysClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayDebugCredentialsContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayKeysContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayTokenContractInner;
import com.azure.resourcemanager.apimanagement.implementation.GatewayContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.GatewayDebugCredentialsContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.GatewayKeysContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.GatewayTokenContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GatewayContract;
import com.azure.resourcemanager.apimanagement.models.GatewayDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeyRegenerationRequestContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeysContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListTraceContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenRequestContract;
import com.azure.resourcemanager.apimanagement.models.Gateways;
import com.azure.resourcemanager.apimanagement.models.GatewaysGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.GatewaysGetResponse;
import com.azure.resourcemanager.apimanagement.models.GatewaysListKeysResponse;
import java.util.Collections;
import java.util.Map;

public final class GatewaysImpl
implements Gateways {
    private static final ClientLogger LOGGER = new ClientLogger(GatewaysImpl.class);
    private final GatewaysClient innerClient;
    private final ApiManagementManager serviceManager;

    public GatewaysImpl(GatewaysClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GatewayContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<GatewayContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayContractImpl((GatewayContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GatewayContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<GatewayContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayContractImpl((GatewayContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public GatewaysGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String gatewayId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String gatewayId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, gatewayId);
    }

    @Override
    public Response<GatewayContract> getWithResponse(String resourceGroupName, String serviceName, String gatewayId, Context context) {
        GatewaysGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, gatewayId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GatewayContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GatewayContract get(String resourceGroupName, String serviceName, String gatewayId) {
        GatewayContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, gatewayId);
        if (inner != null) {
            return new GatewayContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String gatewayId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, gatewayId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String gatewayId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, gatewayId, ifMatch);
    }

    @Override
    public Response<GatewayKeysContract> listKeysWithResponse(String resourceGroupName, String serviceName, String gatewayId, Context context) {
        GatewaysListKeysResponse inner = this.serviceClient().listKeysWithResponse(resourceGroupName, serviceName, gatewayId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GatewayKeysContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GatewayKeysContract listKeys(String resourceGroupName, String serviceName, String gatewayId) {
        GatewayKeysContractInner inner = this.serviceClient().listKeys(resourceGroupName, serviceName, gatewayId);
        if (inner != null) {
            return new GatewayKeysContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> regenerateKeyWithResponse(String resourceGroupName, String serviceName, String gatewayId, GatewayKeyRegenerationRequestContract parameters, Context context) {
        return this.serviceClient().regenerateKeyWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    @Override
    public void regenerateKey(String resourceGroupName, String serviceName, String gatewayId, GatewayKeyRegenerationRequestContract parameters) {
        this.serviceClient().regenerateKey(resourceGroupName, serviceName, gatewayId, parameters);
    }

    @Override
    public Response<GatewayTokenContract> generateTokenWithResponse(String resourceGroupName, String serviceName, String gatewayId, GatewayTokenRequestContract parameters, Context context) {
        Response<GatewayTokenContractInner> inner = this.serviceClient().generateTokenWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GatewayTokenContractImpl((GatewayTokenContractInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GatewayTokenContract generateToken(String resourceGroupName, String serviceName, String gatewayId, GatewayTokenRequestContract parameters) {
        GatewayTokenContractInner inner = this.serviceClient().generateToken(resourceGroupName, serviceName, gatewayId, parameters);
        if (inner != null) {
            return new GatewayTokenContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> invalidateDebugCredentialsWithResponse(String resourceGroupName, String serviceName, String gatewayId, Context context) {
        return this.serviceClient().invalidateDebugCredentialsWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    @Override
    public void invalidateDebugCredentials(String resourceGroupName, String serviceName, String gatewayId) {
        this.serviceClient().invalidateDebugCredentials(resourceGroupName, serviceName, gatewayId);
    }

    @Override
    public Response<GatewayDebugCredentialsContract> listDebugCredentialsWithResponse(String resourceGroupName, String serviceName, String gatewayId, GatewayListDebugCredentialsContract parameters, Context context) {
        Response<GatewayDebugCredentialsContractInner> inner = this.serviceClient().listDebugCredentialsWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GatewayDebugCredentialsContractImpl((GatewayDebugCredentialsContractInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GatewayDebugCredentialsContract listDebugCredentials(String resourceGroupName, String serviceName, String gatewayId, GatewayListDebugCredentialsContract parameters) {
        GatewayDebugCredentialsContractInner inner = this.serviceClient().listDebugCredentials(resourceGroupName, serviceName, gatewayId, parameters);
        if (inner != null) {
            return new GatewayDebugCredentialsContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Map<String, Object>> listTraceWithResponse(String resourceGroupName, String serviceName, String gatewayId, GatewayListTraceContract parameters, Context context) {
        return this.serviceClient().listTraceWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    @Override
    public Map<String, Object> listTrace(String resourceGroupName, String serviceName, String gatewayId, GatewayListTraceContract parameters) {
        Map<String, Object> inner = this.serviceClient().listTrace(resourceGroupName, serviceName, gatewayId, parameters);
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public GatewayContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return (GatewayContract)this.getWithResponse(resourceGroupName, serviceName, gatewayId, Context.NONE).getValue();
    }

    @Override
    public Response<GatewayContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, gatewayId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, gatewayId, ifMatch, context);
    }

    private GatewaysClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GatewayContractImpl define(String name) {
        return new GatewayContractImpl(name, this.manager());
    }
}

