/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.GraphQLApiResolversClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ResolverContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResolverContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolvers;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolversGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolversGetResponse;
import com.azure.resourcemanager.apimanagement.models.ResolverContract;

public final class GraphQLApiResolversImpl
implements GraphQLApiResolvers {
    private static final ClientLogger LOGGER = new ClientLogger(GraphQLApiResolversImpl.class);
    private final GraphQLApiResolversClient innerClient;
    private final ApiManagementManager serviceManager;

    public GraphQLApiResolversImpl(GraphQLApiResolversClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ResolverContract> listByApi(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<ResolverContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResolverContractImpl((ResolverContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ResolverContract> listByApi(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ResolverContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResolverContractImpl((ResolverContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public GraphQLApiResolversGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, resolverId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String resolverId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, resolverId);
    }

    @Override
    public Response<ResolverContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, Context context) {
        GraphQLApiResolversGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, resolverId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ResolverContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ResolverContract get(String resourceGroupName, String serviceName, String apiId, String resolverId) {
        ResolverContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, resolverId);
        if (inner != null) {
            return new ResolverContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, resolverId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String resolverId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, resolverId, ifMatch);
    }

    @Override
    public ResolverContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String resolverId = ResourceManagerUtils.getValueFromIdByName(id, "resolvers");
        if (resolverId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resolvers'.", id)));
        }
        return (ResolverContract)this.getWithResponse(resourceGroupName, serviceName, apiId, resolverId, Context.NONE).getValue();
    }

    @Override
    public Response<ResolverContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String resolverId = ResourceManagerUtils.getValueFromIdByName(id, "resolvers");
        if (resolverId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resolvers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, resolverId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String resolverId = ResourceManagerUtils.getValueFromIdByName(id, "resolvers");
        if (resolverId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resolvers'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, resolverId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String resolverId = ResourceManagerUtils.getValueFromIdByName(id, "resolvers");
        if (resolverId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resolvers'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, resolverId, ifMatch, context);
    }

    private GraphQLApiResolversClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResolverContractImpl define(String name) {
        return new ResolverContractImpl(name, this.manager());
    }
}

