/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GroupContract;
import com.azure.resourcemanager.apimanagement.models.GroupCreateParameters;
import com.azure.resourcemanager.apimanagement.models.GroupType;
import com.azure.resourcemanager.apimanagement.models.GroupUpdateParameters;

public final class GroupContractImpl
implements GroupContract,
GroupContract.Definition,
GroupContract.Update {
    private GroupContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String groupId;
    private String createIfMatch;
    private GroupCreateParameters createParameters;
    private String updateIfMatch;
    private GroupUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Boolean builtIn() {
        return this.innerModel().builtIn();
    }

    @Override
    public GroupType typePropertiesType() {
        return this.innerModel().typePropertiesType();
    }

    @Override
    public String externalId() {
        return this.innerModel().externalId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GroupContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GroupContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public GroupContract create() {
        this.innerObject = this.serviceManager.serviceClient().getGroups().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.groupId, this.createParameters, this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public GroupContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGroups().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.groupId, this.createParameters, this.createIfMatch, context).getValue();
        return this;
    }

    GroupContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new GroupContractInner();
        this.serviceManager = serviceManager;
        this.groupId = name;
        this.createIfMatch = null;
        this.createParameters = new GroupCreateParameters();
    }

    @Override
    public GroupContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new GroupUpdateParameters();
        return this;
    }

    @Override
    public GroupContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getGroups().updateWithResponse(this.resourceGroupName, this.serviceName, this.groupId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public GroupContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGroups().updateWithResponse(this.resourceGroupName, this.serviceName, this.groupId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    GroupContractImpl(GroupContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.groupId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "groups");
    }

    @Override
    public GroupContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getGroups().getWithResponse(this.resourceGroupName, this.serviceName, this.groupId, Context.NONE).getValue();
        return this;
    }

    @Override
    public GroupContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGroups().getWithResponse(this.resourceGroupName, this.serviceName, this.groupId, context).getValue();
        return this;
    }

    @Override
    public GroupContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.createParameters.withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public GroupContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public GroupContractImpl withType(GroupType type) {
        if (this.isInCreateMode()) {
            this.createParameters.withType(type);
            return this;
        }
        this.updateParameters.withType(type);
        return this;
    }

    @Override
    public GroupContractImpl withExternalId(String externalId) {
        if (this.isInCreateMode()) {
            this.createParameters.withExternalId(externalId);
            return this;
        }
        this.updateParameters.withExternalId(externalId);
        return this;
    }

    @Override
    public GroupContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

