/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.GroupUsersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.UserContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.UserContractImpl;
import com.azure.resourcemanager.apimanagement.models.GroupUsers;
import com.azure.resourcemanager.apimanagement.models.UserContract;

public final class GroupUsersImpl
implements GroupUsers {
    private static final ClientLogger LOGGER = new ClientLogger(GroupUsersImpl.class);
    private final GroupUsersClient innerClient;
    private final ApiManagementManager serviceManager;

    public GroupUsersImpl(GroupUsersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<UserContract> list(String resourceGroupName, String serviceName, String groupId) {
        PagedIterable<UserContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, groupId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserContractImpl((UserContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<UserContract> list(String resourceGroupName, String serviceName, String groupId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<UserContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, groupId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserContractImpl((UserContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Boolean> checkEntityExistsWithResponse(String resourceGroupName, String serviceName, String groupId, String userId, Context context) {
        return this.serviceClient().checkEntityExistsWithResponse(resourceGroupName, serviceName, groupId, userId, context);
    }

    @Override
    public boolean checkEntityExists(String resourceGroupName, String serviceName, String groupId, String userId) {
        return this.serviceClient().checkEntityExists(resourceGroupName, serviceName, groupId, userId);
    }

    @Override
    public Response<UserContract> createWithResponse(String resourceGroupName, String serviceName, String groupId, String userId, Context context) {
        Response<UserContractInner> inner = this.serviceClient().createWithResponse(resourceGroupName, serviceName, groupId, userId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UserContractImpl((UserContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public UserContract create(String resourceGroupName, String serviceName, String groupId, String userId) {
        UserContractInner inner = this.serviceClient().create(resourceGroupName, serviceName, groupId, userId);
        if (inner != null) {
            return new UserContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String groupId, String userId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, groupId, userId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String groupId, String userId) {
        this.serviceClient().delete(resourceGroupName, serviceName, groupId, userId);
    }

    private GroupUsersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

