/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.IdentityProviderContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ClientSecretContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderCreateContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderUpdateParameters;
import java.util.Collections;
import java.util.List;

public final class IdentityProviderContractImpl
implements IdentityProviderContract,
IdentityProviderContract.Definition,
IdentityProviderContract.Update {
    private IdentityProviderContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private IdentityProviderType identityProviderName;
    private String createIfMatch;
    private IdentityProviderCreateContract createParameters;
    private String updateIfMatch;
    private IdentityProviderUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String clientId() {
        return this.innerModel().clientId();
    }

    @Override
    public String clientSecret() {
        return this.innerModel().clientSecret();
    }

    @Override
    public IdentityProviderType typePropertiesType() {
        return this.innerModel().typePropertiesType();
    }

    @Override
    public String signinTenant() {
        return this.innerModel().signinTenant();
    }

    @Override
    public List<String> allowedTenants() {
        List<String> inner = this.innerModel().allowedTenants();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String authority() {
        return this.innerModel().authority();
    }

    @Override
    public String signupPolicyName() {
        return this.innerModel().signupPolicyName();
    }

    @Override
    public String signinPolicyName() {
        return this.innerModel().signinPolicyName();
    }

    @Override
    public String profileEditingPolicyName() {
        return this.innerModel().profileEditingPolicyName();
    }

    @Override
    public String passwordResetPolicyName() {
        return this.innerModel().passwordResetPolicyName();
    }

    @Override
    public String clientLibrary() {
        return this.innerModel().clientLibrary();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IdentityProviderContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IdentityProviderContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public IdentityProviderContract create() {
        this.innerObject = this.serviceManager.serviceClient().getIdentityProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.identityProviderName, this.createParameters, this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public IdentityProviderContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getIdentityProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.identityProviderName, this.createParameters, this.createIfMatch, context).getValue();
        return this;
    }

    IdentityProviderContractImpl(IdentityProviderType name, ApiManagementManager serviceManager) {
        this.innerObject = new IdentityProviderContractInner();
        this.serviceManager = serviceManager;
        this.identityProviderName = name;
        this.createIfMatch = null;
        this.createParameters = new IdentityProviderCreateContract();
    }

    @Override
    public IdentityProviderContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new IdentityProviderUpdateParameters();
        return this;
    }

    @Override
    public IdentityProviderContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getIdentityProviders().updateWithResponse(this.resourceGroupName, this.serviceName, this.identityProviderName, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public IdentityProviderContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getIdentityProviders().updateWithResponse(this.resourceGroupName, this.serviceName, this.identityProviderName, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    IdentityProviderContractImpl(IdentityProviderContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.identityProviderName = IdentityProviderType.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "identityProviders"));
    }

    @Override
    public IdentityProviderContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getIdentityProviders().getWithResponse(this.resourceGroupName, this.serviceName, this.identityProviderName, Context.NONE).getValue();
        return this;
    }

    @Override
    public IdentityProviderContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getIdentityProviders().getWithResponse(this.resourceGroupName, this.serviceName, this.identityProviderName, context).getValue();
        return this;
    }

    @Override
    public Response<ClientSecretContract> listSecretsWithResponse(Context context) {
        return this.serviceManager.identityProviders().listSecretsWithResponse(this.resourceGroupName, this.serviceName, this.identityProviderName, context);
    }

    @Override
    public ClientSecretContract listSecrets() {
        return this.serviceManager.identityProviders().listSecrets(this.resourceGroupName, this.serviceName, this.identityProviderName);
    }

    @Override
    public IdentityProviderContractImpl withClientId(String clientId) {
        if (this.isInCreateMode()) {
            this.createParameters.withClientId(clientId);
            return this;
        }
        this.updateParameters.withClientId(clientId);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withClientSecret(String clientSecret) {
        if (this.isInCreateMode()) {
            this.createParameters.withClientSecret(clientSecret);
            return this;
        }
        this.updateParameters.withClientSecret(clientSecret);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withTypePropertiesType(IdentityProviderType typePropertiesType) {
        this.createParameters.withTypePropertiesType(typePropertiesType);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withSigninTenant(String signinTenant) {
        if (this.isInCreateMode()) {
            this.createParameters.withSigninTenant(signinTenant);
            return this;
        }
        this.updateParameters.withSigninTenant(signinTenant);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withAllowedTenants(List<String> allowedTenants) {
        if (this.isInCreateMode()) {
            this.createParameters.withAllowedTenants(allowedTenants);
            return this;
        }
        this.updateParameters.withAllowedTenants(allowedTenants);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withAuthority(String authority) {
        if (this.isInCreateMode()) {
            this.createParameters.withAuthority(authority);
            return this;
        }
        this.updateParameters.withAuthority(authority);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withSignupPolicyName(String signupPolicyName) {
        if (this.isInCreateMode()) {
            this.createParameters.withSignupPolicyName(signupPolicyName);
            return this;
        }
        this.updateParameters.withSignupPolicyName(signupPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withSigninPolicyName(String signinPolicyName) {
        if (this.isInCreateMode()) {
            this.createParameters.withSigninPolicyName(signinPolicyName);
            return this;
        }
        this.updateParameters.withSigninPolicyName(signinPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withProfileEditingPolicyName(String profileEditingPolicyName) {
        if (this.isInCreateMode()) {
            this.createParameters.withProfileEditingPolicyName(profileEditingPolicyName);
            return this;
        }
        this.updateParameters.withProfileEditingPolicyName(profileEditingPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withPasswordResetPolicyName(String passwordResetPolicyName) {
        if (this.isInCreateMode()) {
            this.createParameters.withPasswordResetPolicyName(passwordResetPolicyName);
            return this;
        }
        this.updateParameters.withPasswordResetPolicyName(passwordResetPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withClientLibrary(String clientLibrary) {
        if (this.isInCreateMode()) {
            this.createParameters.withClientLibrary(clientLibrary);
            return this;
        }
        this.updateParameters.withClientLibrary(clientLibrary);
        return this;
    }

    @Override
    public IdentityProviderContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public IdentityProviderContractImpl withType(IdentityProviderType type) {
        this.updateParameters.withType(type);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

