/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.IdentityProvidersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ClientSecretContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.IdentityProviderContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ClientSecretContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.IdentityProviderContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ClientSecretContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderContract;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import com.azure.resourcemanager.apimanagement.models.IdentityProviders;
import com.azure.resourcemanager.apimanagement.models.IdentityProvidersGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.IdentityProvidersGetResponse;
import com.azure.resourcemanager.apimanagement.models.IdentityProvidersListSecretsResponse;

public final class IdentityProvidersImpl
implements IdentityProviders {
    private static final ClientLogger LOGGER = new ClientLogger(IdentityProvidersImpl.class);
    private final IdentityProvidersClient innerClient;
    private final ApiManagementManager serviceManager;

    public IdentityProvidersImpl(IdentityProvidersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IdentityProviderContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<IdentityProviderContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IdentityProviderContractImpl((IdentityProviderContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IdentityProviderContract> listByService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<IdentityProviderContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IdentityProviderContractImpl((IdentityProviderContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public IdentityProvidersGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, identityProviderName, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, identityProviderName);
    }

    @Override
    public Response<IdentityProviderContract> getWithResponse(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName, Context context) {
        IdentityProvidersGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, identityProviderName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IdentityProviderContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IdentityProviderContract get(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName) {
        IdentityProviderContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, identityProviderName);
        if (inner != null) {
            return new IdentityProviderContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, identityProviderName, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, identityProviderName, ifMatch);
    }

    @Override
    public Response<ClientSecretContract> listSecretsWithResponse(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName, Context context) {
        IdentityProvidersListSecretsResponse inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, serviceName, identityProviderName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClientSecretContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ClientSecretContract listSecrets(String resourceGroupName, String serviceName, IdentityProviderType identityProviderName) {
        ClientSecretContractInner inner = this.serviceClient().listSecrets(resourceGroupName, serviceName, identityProviderName);
        if (inner != null) {
            return new ClientSecretContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public IdentityProviderContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        return (IdentityProviderContract)this.getWithResponse(resourceGroupName, serviceName, identityProviderName, Context.NONE).getValue();
    }

    @Override
    public Response<IdentityProviderContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        return this.getWithResponse(resourceGroupName, serviceName, identityProviderName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, identityProviderName, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String identityProviderNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "identityProviders");
        if (identityProviderNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'identityProviders'.", id)));
        }
        IdentityProviderType identityProviderName = IdentityProviderType.fromString(identityProviderNameLocal);
        return this.deleteWithResponse(resourceGroupName, serviceName, identityProviderName, ifMatch, context);
    }

    private IdentityProvidersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IdentityProviderContractImpl define(IdentityProviderType name) {
        return new IdentityProviderContractImpl(name, this.manager());
    }
}

