/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueAttachmentContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.IssueAttachmentContract;

public final class IssueAttachmentContractImpl
implements IssueAttachmentContract,
IssueAttachmentContract.Definition,
IssueAttachmentContract.Update {
    private IssueAttachmentContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String issueId;
    private String attachmentId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String title() {
        return this.innerModel().title();
    }

    @Override
    public String contentFormat() {
        return this.innerModel().contentFormat();
    }

    @Override
    public String content() {
        return this.innerModel().content();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IssueAttachmentContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IssueAttachmentContractImpl withExistingIssue(String resourceGroupName, String serviceName, String apiId, String issueId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        this.issueId = issueId;
        return this;
    }

    @Override
    public IssueAttachmentContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueAttachments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.attachmentId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueAttachmentContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueAttachments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.attachmentId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    IssueAttachmentContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new IssueAttachmentContractInner();
        this.serviceManager = serviceManager;
        this.attachmentId = name;
        this.createIfMatch = null;
    }

    @Override
    public IssueAttachmentContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public IssueAttachmentContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueAttachments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.attachmentId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueAttachmentContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueAttachments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.attachmentId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    IssueAttachmentContractImpl(IssueAttachmentContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.issueId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "issues");
        this.attachmentId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "attachments");
    }

    @Override
    public IssueAttachmentContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueAttachments().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.attachmentId, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueAttachmentContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueAttachments().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.attachmentId, context).getValue();
        return this;
    }

    @Override
    public IssueAttachmentContractImpl withTitle(String title) {
        this.innerModel().withTitle(title);
        return this;
    }

    @Override
    public IssueAttachmentContractImpl withContentFormat(String contentFormat) {
        this.innerModel().withContentFormat(contentFormat);
        return this;
    }

    @Override
    public IssueAttachmentContractImpl withContent(String content) {
        this.innerModel().withContent(content);
        return this;
    }

    @Override
    public IssueAttachmentContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

