/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.IssueContract;
import com.azure.resourcemanager.apimanagement.models.IssueUpdateContract;
import com.azure.resourcemanager.apimanagement.models.State;
import java.time.OffsetDateTime;

public final class IssueContractImpl
implements IssueContract,
IssueContract.Definition,
IssueContract.Update {
    private IssueContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String issueId;
    private String createIfMatch;
    private String updateIfMatch;
    private IssueUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String title() {
        return this.innerModel().title();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String userId() {
        return this.innerModel().userId();
    }

    @Override
    public OffsetDateTime createdDate() {
        return this.innerModel().createdDate();
    }

    @Override
    public State state() {
        return this.innerModel().state();
    }

    @Override
    public String apiId() {
        return this.innerModel().apiId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IssueContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IssueContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    @Override
    public IssueContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssues().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssues().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    IssueContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new IssueContractInner();
        this.serviceManager = serviceManager;
        this.issueId = name;
        this.createIfMatch = null;
    }

    @Override
    public IssueContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new IssueUpdateContract();
        return this;
    }

    @Override
    public IssueContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssues().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssues().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    IssueContractImpl(IssueContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.issueId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "issues");
    }

    @Override
    public IssueContract refresh() {
        Boolean localExpandCommentsAttachments = null;
        this.innerObject = this.serviceManager.serviceClient().getApiIssues().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, localExpandCommentsAttachments, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueContract refresh(Context context) {
        Boolean localExpandCommentsAttachments = null;
        this.innerObject = this.serviceManager.serviceClient().getApiIssues().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, localExpandCommentsAttachments, context).getValue();
        return this;
    }

    @Override
    public IssueContractImpl withTitle(String title) {
        if (this.isInCreateMode()) {
            this.innerModel().withTitle(title);
            return this;
        }
        this.updateParameters.withTitle(title);
        return this;
    }

    @Override
    public IssueContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public IssueContractImpl withUserId(String userId) {
        if (this.isInCreateMode()) {
            this.innerModel().withUserId(userId);
            return this;
        }
        this.updateParameters.withUserId(userId);
        return this;
    }

    @Override
    public IssueContractImpl withCreatedDate(OffsetDateTime createdDate) {
        if (this.isInCreateMode()) {
            this.innerModel().withCreatedDate(createdDate);
            return this;
        }
        this.updateParameters.withCreatedDate(createdDate);
        return this;
    }

    @Override
    public IssueContractImpl withState(State state) {
        if (this.isInCreateMode()) {
            this.innerModel().withState(state);
            return this;
        }
        this.updateParameters.withState(state);
        return this;
    }

    @Override
    public IssueContractImpl withApiId(String apiId) {
        if (this.isInCreateMode()) {
            this.innerModel().withApiId(apiId);
            return this;
        }
        this.updateParameters.withApiId(apiId);
        return this;
    }

    @Override
    public IssueContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

