/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.NamedValuesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueSecretContractInner;
import com.azure.resourcemanager.apimanagement.implementation.NamedValueContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.NamedValueSecretContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.NamedValueContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueSecretContract;
import com.azure.resourcemanager.apimanagement.models.NamedValues;
import com.azure.resourcemanager.apimanagement.models.NamedValuesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.NamedValuesGetResponse;
import com.azure.resourcemanager.apimanagement.models.NamedValuesListValueResponse;

public final class NamedValuesImpl
implements NamedValues {
    private static final ClientLogger LOGGER = new ClientLogger(NamedValuesImpl.class);
    private final NamedValuesClient innerClient;
    private final ApiManagementManager serviceManager;

    public NamedValuesImpl(NamedValuesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<NamedValueContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<NamedValueContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamedValueContractImpl((NamedValueContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NamedValueContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed, Context context) {
        PagedIterable<NamedValueContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamedValueContractImpl((NamedValueContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public NamedValuesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, namedValueId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String namedValueId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, namedValueId);
    }

    @Override
    public Response<NamedValueContract> getWithResponse(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        NamedValuesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, namedValueId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NamedValueContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NamedValueContract get(String resourceGroupName, String serviceName, String namedValueId) {
        NamedValueContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, namedValueId);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, namedValueId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String namedValueId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, namedValueId, ifMatch);
    }

    @Override
    public Response<NamedValueSecretContract> listValueWithResponse(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        NamedValuesListValueResponse inner = this.serviceClient().listValueWithResponse(resourceGroupName, serviceName, namedValueId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NamedValueSecretContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NamedValueSecretContract listValue(String resourceGroupName, String serviceName, String namedValueId) {
        NamedValueSecretContractInner inner = this.serviceClient().listValue(resourceGroupName, serviceName, namedValueId);
        if (inner != null) {
            return new NamedValueSecretContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public NamedValueContract refreshSecret(String resourceGroupName, String serviceName, String namedValueId) {
        NamedValueContractInner inner = this.serviceClient().refreshSecret(resourceGroupName, serviceName, namedValueId);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public NamedValueContract refreshSecret(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        NamedValueContractInner inner = this.serviceClient().refreshSecret(resourceGroupName, serviceName, namedValueId, context);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public NamedValueContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        return (NamedValueContract)this.getWithResponse(resourceGroupName, serviceName, namedValueId, Context.NONE).getValue();
    }

    @Override
    public Response<NamedValueContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, namedValueId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, namedValueId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String namedValueId = ResourceManagerUtils.getValueFromIdByName(id, "namedValues");
        if (namedValueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namedValues'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, namedValueId, ifMatch, context);
    }

    private NamedValuesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public NamedValueContractImpl define(String name) {
        return new NamedValueContractImpl(name, this.manager());
    }
}

