/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.NetworkStatusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.NetworkStatusContractByLocationInner;
import com.azure.resourcemanager.apimanagement.fluent.models.NetworkStatusContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class NetworkStatusClientImpl
implements NetworkStatusClient {
    private final NetworkStatusService service;
    private final ApiManagementClientImpl client;

    NetworkStatusClientImpl(ApiManagementClientImpl client) {
        this.service = (NetworkStatusService)RestProxy.create(NetworkStatusService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<NetworkStatusContractByLocationInner>>> listByServiceWithResponseAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serviceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<NetworkStatusContractByLocationInner>>> listByServiceWithResponseAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serviceName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<List<NetworkStatusContractByLocationInner>> listByServiceAsync(String resourceGroupName, String serviceName) {
        return this.listByServiceWithResponseAsync(resourceGroupName, serviceName).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<NetworkStatusContractByLocationInner>> listByServiceWithResponse(String resourceGroupName, String serviceName, Context context) {
        return (Response)this.listByServiceWithResponseAsync(resourceGroupName, serviceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<NetworkStatusContractByLocationInner> listByService(String resourceGroupName, String serviceName) {
        return (List)this.listByServiceWithResponse(resourceGroupName, serviceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkStatusContractInner>> listByLocationWithResponseAsync(String resourceGroupName, String serviceName, String locationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocation(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serviceName, locationName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkStatusContractInner>> listByLocationWithResponseAsync(String resourceGroupName, String serviceName, String locationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocation(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serviceName, locationName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NetworkStatusContractInner> listByLocationAsync(String resourceGroupName, String serviceName, String locationName) {
        return this.listByLocationWithResponseAsync(resourceGroupName, serviceName, locationName).flatMap(res -> Mono.justOrEmpty((Object)((NetworkStatusContractInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkStatusContractInner> listByLocationWithResponse(String resourceGroupName, String serviceName, String locationName, Context context) {
        return (Response)this.listByLocationWithResponseAsync(resourceGroupName, serviceName, locationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkStatusContractInner listByLocation(String resourceGroupName, String serviceName, String locationName) {
        return (NetworkStatusContractInner)this.listByLocationWithResponse(resourceGroupName, serviceName, locationName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientN")
    public static interface NetworkStatusService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/networkstatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<NetworkStatusContractByLocationInner>>> listByService(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="serviceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/locations/{locationName}/networkstatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkStatusContractInner>> listByLocation(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="locationName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

