/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.OperationContract;
import com.azure.resourcemanager.apimanagement.models.OperationUpdateContract;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.RequestContract;
import com.azure.resourcemanager.apimanagement.models.ResponseContract;
import java.util.Collections;
import java.util.List;

public final class OperationContractImpl
implements OperationContract,
OperationContract.Definition,
OperationContract.Update {
    private OperationContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String operationId;
    private String createIfMatch;
    private String updateIfMatch;
    private OperationUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String method() {
        return this.innerModel().method();
    }

    @Override
    public String urlTemplate() {
        return this.innerModel().urlTemplate();
    }

    @Override
    public List<ParameterContract> templateParameters() {
        List<ParameterContract> inner = this.innerModel().templateParameters();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public RequestContract request() {
        return this.innerModel().request();
    }

    @Override
    public List<ResponseContract> responses() {
        List<ResponseContract> inner = this.innerModel().responses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String policies() {
        return this.innerModel().policies();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public OperationContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public OperationContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    @Override
    public OperationContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiOperations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public OperationContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiOperations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    OperationContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new OperationContractInner();
        this.serviceManager = serviceManager;
        this.operationId = name;
        this.createIfMatch = null;
    }

    @Override
    public OperationContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new OperationUpdateContract();
        return this;
    }

    @Override
    public OperationContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiOperations().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public OperationContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiOperations().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    OperationContractImpl(OperationContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.operationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "operations");
    }

    @Override
    public OperationContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiOperations().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, Context.NONE).getValue();
        return this;
    }

    @Override
    public OperationContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiOperations().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, context).getValue();
        return this;
    }

    @Override
    public OperationContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public OperationContractImpl withMethod(String method) {
        if (this.isInCreateMode()) {
            this.innerModel().withMethod(method);
            return this;
        }
        this.updateParameters.withMethod(method);
        return this;
    }

    @Override
    public OperationContractImpl withUrlTemplate(String urlTemplate) {
        if (this.isInCreateMode()) {
            this.innerModel().withUrlTemplate(urlTemplate);
            return this;
        }
        this.updateParameters.withUrlTemplate(urlTemplate);
        return this;
    }

    @Override
    public OperationContractImpl withTemplateParameters(List<ParameterContract> templateParameters) {
        if (this.isInCreateMode()) {
            this.innerModel().withTemplateParameters(templateParameters);
            return this;
        }
        this.updateParameters.withTemplateParameters(templateParameters);
        return this;
    }

    @Override
    public OperationContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public OperationContractImpl withRequest(RequestContract request) {
        if (this.isInCreateMode()) {
            this.innerModel().withRequest(request);
            return this;
        }
        this.updateParameters.withRequest(request);
        return this;
    }

    @Override
    public OperationContractImpl withResponses(List<ResponseContract> responses) {
        if (this.isInCreateMode()) {
            this.innerModel().withResponses(responses);
            return this;
        }
        this.updateParameters.withResponses(responses);
        return this;
    }

    @Override
    public OperationContractImpl withPolicies(String policies) {
        if (this.isInCreateMode()) {
            this.innerModel().withPolicies(policies);
            return this;
        }
        this.updateParameters.withPolicies(policies);
        return this;
    }

    @Override
    public OperationContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

