/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.OperationStatusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.apimanagement.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.apimanagement.models.OperationStatus;
import com.azure.resourcemanager.apimanagement.models.OperationStatusResult;

public final class OperationStatusImpl
implements OperationStatus {
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusImpl.class);
    private final OperationStatusClient innerClient;
    private final ApiManagementManager serviceManager;

    public OperationStatusImpl(OperationStatusClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationStatusResult> getWithResponse(String location, String operationId, Context context) {
        Response<OperationStatusResultInner> inner = this.serviceClient().getWithResponse(location, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationStatusResultImpl((OperationStatusResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationStatusResult get(String location, String operationId) {
        OperationStatusResultInner inner = this.serviceClient().get(location, operationId);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    private OperationStatusClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

