/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.OperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagResourceContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagResourceContractImpl;
import com.azure.resourcemanager.apimanagement.models.Operations;
import com.azure.resourcemanager.apimanagement.models.TagResourceContract;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagResourceContract> listByTags(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<TagResourceContractInner> inner = this.serviceClient().listByTags(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagResourceContractImpl((TagResourceContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<TagResourceContract> listByTags(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Boolean includeNotTaggedOperations, Context context) {
        PagedIterable<TagResourceContractInner> inner = this.serviceClient().listByTags(resourceGroupName, serviceName, apiId, filter, top, skip, includeNotTaggedOperations, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagResourceContractImpl((TagResourceContractInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

