/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyFragmentContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContentFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContract;
import com.azure.resourcemanager.apimanagement.models.ResourceCollection;

public final class PolicyFragmentContractImpl
implements PolicyFragmentContract,
PolicyFragmentContract.Definition,
PolicyFragmentContract.Update {
    private PolicyFragmentContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String id;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public PolicyFragmentContentFormat format() {
        return this.innerModel().format();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PolicyFragmentContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PolicyFragmentContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public PolicyFragmentContract create() {
        this.innerObject = this.serviceManager.serviceClient().getPolicyFragments().createOrUpdate(this.resourceGroupName, this.serviceName, this.id, this.innerModel(), this.createIfMatch, Context.NONE);
        return this;
    }

    @Override
    public PolicyFragmentContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPolicyFragments().createOrUpdate(this.resourceGroupName, this.serviceName, this.id, this.innerModel(), this.createIfMatch, context);
        return this;
    }

    PolicyFragmentContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new PolicyFragmentContractInner();
        this.serviceManager = serviceManager;
        this.id = name;
        this.createIfMatch = null;
    }

    @Override
    public PolicyFragmentContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public PolicyFragmentContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getPolicyFragments().createOrUpdate(this.resourceGroupName, this.serviceName, this.id, this.innerModel(), this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public PolicyFragmentContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPolicyFragments().createOrUpdate(this.resourceGroupName, this.serviceName, this.id, this.innerModel(), this.updateIfMatch, context);
        return this;
    }

    PolicyFragmentContractImpl(PolicyFragmentContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.id = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "policyFragments");
    }

    @Override
    public PolicyFragmentContract refresh() {
        PolicyFragmentContentFormat localFormat = null;
        this.innerObject = this.serviceManager.serviceClient().getPolicyFragments().getWithResponse(this.resourceGroupName, this.serviceName, this.id, localFormat, Context.NONE).getValue();
        return this;
    }

    @Override
    public PolicyFragmentContract refresh(Context context) {
        PolicyFragmentContentFormat localFormat = null;
        this.innerObject = this.serviceManager.serviceClient().getPolicyFragments().getWithResponse(this.resourceGroupName, this.serviceName, this.id, localFormat, context).getValue();
        return this;
    }

    @Override
    public Response<ResourceCollection> listReferencesWithResponse(Integer top, Integer skip, Context context) {
        return this.serviceManager.policyFragments().listReferencesWithResponse(this.resourceGroupName, this.serviceName, this.id, top, skip, context);
    }

    @Override
    public ResourceCollection listReferences() {
        return this.serviceManager.policyFragments().listReferences(this.resourceGroupName, this.serviceName, this.id);
    }

    @Override
    public PolicyFragmentContractImpl withValue(String value) {
        this.innerModel().withValue(value);
        return this;
    }

    @Override
    public PolicyFragmentContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public PolicyFragmentContractImpl withFormat(PolicyFragmentContentFormat format) {
        this.innerModel().withFormat(format);
        return this;
    }

    @Override
    public PolicyFragmentContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

