/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.PolicyRestrictionValidationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import com.azure.resourcemanager.apimanagement.implementation.OperationResultContractImpl;
import com.azure.resourcemanager.apimanagement.models.OperationResultContract;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionValidations;

public final class PolicyRestrictionValidationsImpl
implements PolicyRestrictionValidations {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyRestrictionValidationsImpl.class);
    private final PolicyRestrictionValidationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public PolicyRestrictionValidationsImpl(PolicyRestrictionValidationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public OperationResultContract byService(String resourceGroupName, String serviceName) {
        OperationResultContractInner inner = this.serviceClient().byService(resourceGroupName, serviceName);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationResultContract byService(String resourceGroupName, String serviceName, Context context) {
        OperationResultContractInner inner = this.serviceClient().byService(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    private PolicyRestrictionValidationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

