/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalConfigContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PortalConfigContract;
import com.azure.resourcemanager.apimanagement.models.PortalConfigCorsProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigCspProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigDelegationProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigPropertiesSignin;
import com.azure.resourcemanager.apimanagement.models.PortalConfigPropertiesSignup;

public final class PortalConfigContractImpl
implements PortalConfigContract,
PortalConfigContract.Definition,
PortalConfigContract.Update {
    private PortalConfigContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String portalConfigId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Boolean enableBasicAuth() {
        return this.innerModel().enableBasicAuth();
    }

    @Override
    public PortalConfigPropertiesSignin signin() {
        return this.innerModel().signin();
    }

    @Override
    public PortalConfigPropertiesSignup signup() {
        return this.innerModel().signup();
    }

    @Override
    public PortalConfigDelegationProperties delegation() {
        return this.innerModel().delegation();
    }

    @Override
    public PortalConfigCorsProperties cors() {
        return this.innerModel().cors();
    }

    @Override
    public PortalConfigCspProperties csp() {
        return this.innerModel().csp();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PortalConfigContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PortalConfigContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public PortalConfigContract create() {
        this.innerObject = (PortalConfigContractInner)((Object)this.serviceManager.serviceClient().getPortalConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.portalConfigId, this.createIfMatch, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public PortalConfigContract create(Context context) {
        this.innerObject = (PortalConfigContractInner)((Object)this.serviceManager.serviceClient().getPortalConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.portalConfigId, this.createIfMatch, this.innerModel(), context).getValue());
        return this;
    }

    PortalConfigContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new PortalConfigContractInner();
        this.serviceManager = serviceManager;
        this.portalConfigId = name;
        this.createIfMatch = null;
    }

    @Override
    public PortalConfigContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public PortalConfigContract apply() {
        this.innerObject = (PortalConfigContractInner)((Object)this.serviceManager.serviceClient().getPortalConfigs().updateWithResponse(this.resourceGroupName, this.serviceName, this.portalConfigId, this.updateIfMatch, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public PortalConfigContract apply(Context context) {
        this.innerObject = (PortalConfigContractInner)((Object)this.serviceManager.serviceClient().getPortalConfigs().updateWithResponse(this.resourceGroupName, this.serviceName, this.portalConfigId, this.updateIfMatch, this.innerModel(), context).getValue());
        return this;
    }

    PortalConfigContractImpl(PortalConfigContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.portalConfigId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "portalconfigs");
    }

    @Override
    public PortalConfigContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getPortalConfigs().getWithResponse(this.resourceGroupName, this.serviceName, this.portalConfigId, Context.NONE).getValue();
        return this;
    }

    @Override
    public PortalConfigContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPortalConfigs().getWithResponse(this.resourceGroupName, this.serviceName, this.portalConfigId, context).getValue();
        return this;
    }

    @Override
    public PortalConfigContractImpl withEnableBasicAuth(Boolean enableBasicAuth) {
        this.innerModel().withEnableBasicAuth(enableBasicAuth);
        return this;
    }

    @Override
    public PortalConfigContractImpl withSignin(PortalConfigPropertiesSignin signin) {
        this.innerModel().withSignin(signin);
        return this;
    }

    @Override
    public PortalConfigContractImpl withSignup(PortalConfigPropertiesSignup signup) {
        this.innerModel().withSignup(signup);
        return this;
    }

    @Override
    public PortalConfigContractImpl withDelegation(PortalConfigDelegationProperties delegation) {
        this.innerModel().withDelegation(delegation);
        return this;
    }

    @Override
    public PortalConfigContractImpl withCors(PortalConfigCorsProperties cors) {
        this.innerModel().withCors(cors);
        return this;
    }

    @Override
    public PortalConfigContractImpl withCsp(PortalConfigCspProperties csp) {
        this.innerModel().withCsp(csp);
        return this;
    }

    @Override
    public PortalConfigContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

