/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.PortalSettingsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSettingsCollectionInner;
import com.azure.resourcemanager.apimanagement.implementation.PortalSettingsCollectionImpl;
import com.azure.resourcemanager.apimanagement.models.PortalSettings;
import com.azure.resourcemanager.apimanagement.models.PortalSettingsCollection;

public final class PortalSettingsImpl
implements PortalSettings {
    private static final ClientLogger LOGGER = new ClientLogger(PortalSettingsImpl.class);
    private final PortalSettingsClient innerClient;
    private final ApiManagementManager serviceManager;

    public PortalSettingsImpl(PortalSettingsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PortalSettingsCollection> listByServiceWithResponse(String resourceGroupName, String serviceName, Context context) {
        Response<PortalSettingsCollectionInner> inner = this.serviceClient().listByServiceWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PortalSettingsCollectionImpl((PortalSettingsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PortalSettingsCollection listByService(String resourceGroupName, String serviceName) {
        PortalSettingsCollectionInner inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        if (inner != null) {
            return new PortalSettingsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    private PortalSettingsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

