/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.apimanagement.fluent.models.PrivateLinkResourceListResultInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionListResult;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PrivateEndpointConnectionsClientImpl
implements PrivateEndpointConnectionsClient {
    private final PrivateEndpointConnectionsService service;
    private final ApiManagementClientImpl client;

    PrivateEndpointConnectionsClientImpl(ApiManagementClientImpl client) {
        this.service = (PrivateEndpointConnectionsService)RestProxy.create(PrivateEndpointConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serviceName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serviceName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PrivateEndpointConnectionInner> listByServiceAsync(String resourceGroupName, String serviceName) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PrivateEndpointConnectionInner> listByServiceAsync(String resourceGroupName, String serviceName, Context context) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateEndpointConnectionInner> listByService(String resourceGroupName, String serviceName) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateEndpointConnectionInner> listByService(String resourceGroupName, String serviceName, Context context) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateEndpointConnectionInner>> getByNameWithResponseAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByName(this.client.getEndpoint(), resourceGroupName, serviceName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateEndpointConnectionInner>> getByNameWithResponseAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByName(this.client.getEndpoint(), resourceGroupName, serviceName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> getByNameAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        return this.getByNameWithResponseAsync(resourceGroupName, serviceName, privateEndpointConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PrivateEndpointConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateEndpointConnectionInner> getByNameWithResponse(String resourceGroupName, String serviceName, String privateEndpointConnectionName, Context context) {
        return (Response)this.getByNameWithResponseAsync(resourceGroupName, serviceName, privateEndpointConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner getByName(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)this.getByNameWithResponse(resourceGroupName, serviceName, privateEndpointConnectionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointConnectionRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionRequest is required and cannot be null."));
        }
        privateEndpointConnectionRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), privateEndpointConnectionRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointConnectionRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionRequest is required and cannot be null."));
        }
        privateEndpointConnectionRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), privateEndpointConnectionRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner createOrUpdate(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest) {
        return (PrivateEndpointConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner createOrUpdate(String resourceGroupName, String serviceName, String privateEndpointConnectionName, PrivateEndpointConnectionRequest privateEndpointConnectionRequest, Context context) {
        return (PrivateEndpointConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, privateEndpointConnectionName, privateEndpointConnectionRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, privateEndpointConnectionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, privateEndpointConnectionName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, privateEndpointConnectionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String privateEndpointConnectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, privateEndpointConnectionName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, privateEndpointConnectionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String privateEndpointConnectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, privateEndpointConnectionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String privateEndpointConnectionName) {
        this.deleteAsync(resourceGroupName, serviceName, privateEndpointConnectionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String privateEndpointConnectionName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, privateEndpointConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceListResultInner>> listPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), serviceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceListResultInner>> listPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), serviceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateLinkResourceListResultInner> listPrivateLinkResourcesAsync(String resourceGroupName, String serviceName) {
        return this.listPrivateLinkResourcesWithResponseAsync(resourceGroupName, serviceName).flatMap(res -> Mono.justOrEmpty((Object)((PrivateLinkResourceListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourceListResultInner> listPrivateLinkResourcesWithResponse(String resourceGroupName, String serviceName, Context context) {
        return (Response)this.listPrivateLinkResourcesWithResponseAsync(resourceGroupName, serviceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourceListResultInner listPrivateLinkResources(String resourceGroupName, String serviceName) {
        return (PrivateLinkResourceListResultInner)this.listPrivateLinkResourcesWithResponse(resourceGroupName, serviceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceInner>> getPrivateLinkResourceWithResponseAsync(String resourceGroupName, String serviceName, String privateLinkSubResourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateLinkSubResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateLinkSubResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateLinkResource(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), serviceName, privateLinkSubResourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceInner>> getPrivateLinkResourceWithResponseAsync(String resourceGroupName, String serviceName, String privateLinkSubResourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (privateLinkSubResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateLinkSubResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateLinkResource(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), serviceName, privateLinkSubResourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateLinkResourceInner> getPrivateLinkResourceAsync(String resourceGroupName, String serviceName, String privateLinkSubResourceName) {
        return this.getPrivateLinkResourceWithResponseAsync(resourceGroupName, serviceName, privateLinkSubResourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PrivateLinkResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourceInner> getPrivateLinkResourceWithResponse(String resourceGroupName, String serviceName, String privateLinkSubResourceName, Context context) {
        return (Response)this.getPrivateLinkResourceWithResponseAsync(resourceGroupName, serviceName, privateLinkSubResourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourceInner getPrivateLinkResource(String resourceGroupName, String serviceName, String privateLinkSubResourceName) {
        return (PrivateLinkResourceInner)((Object)this.getPrivateLinkResourceWithResponse(resourceGroupName, serviceName, privateLinkSubResourceName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientP")
    public static interface PrivateEndpointConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateEndpointConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateEndpointConnectionListResult>> listByService(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="serviceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateEndpointConnectionInner>> getByName(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="privateEndpointConnectionName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="privateEndpointConnectionName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") PrivateEndpointConnectionRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="privateEndpointConnectionName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceListResultInner>> listPrivateLinkResources(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateLinkResources/{privateLinkSubResourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceInner>> getPrivateLinkResource(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="privateLinkSubResourceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

